/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.SpatialDisorientation.SpatialDisorientationStaff;

public class SpatialDisorientationMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_BEAM = "MAHOUTSUKAI_BEAM";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_SHOOTING_TICKS = "MAHOUTSUKAI_SHOOTING_TICKS";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    public static final int loadUpTime = 20;
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHOOTING_TICKS = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(SpatialDisorientationMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    Vec3 target;
    public UUID casterUUID = null;
    public static final String entityName = "spatial_mahoujin_entity";

    public SpatialDisorientationMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public SpatialDisorientationMahoujinEntity(Level world) {
        super((EntityType)ModEntities.SPATIAL_DISORIENTATION.get(), world);
        this.noCulling = true;
    }

    public SpatialDisorientationMahoujinEntity(Level world, Player caster) {
        this(world);
        this.casterUUID = caster.getUUID();
    }

    public SpatialDisorientationMahoujinEntity(Level world, Player caster, float r, float g, float b, float a) {
        this(world);
        this.casterUUID = caster.getUUID();
        this.setColor(r, g, b, a);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(SHOOTING_TICKS, (Object)-1);
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        if (this.getLife() < 20) {
            this.setLife(this.getLife() + 1);
        }
        this.yRotO = this.yRot;
        if (this.yRotO < 0.0f) {
            this.yRotO += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.yRot = this.getRotationYaw();
        this.xRot = this.getRotationPitch();
        this.setRot(this.yRot, this.xRot);
        if (!this.level().isClientSide) {
            if (this.casterUUID == null) {
                this.discard();
            } else {
                Player caster = this.level().getPlayerByUUID(this.casterUUID);
                if (caster == null || !caster.isAlive()) {
                    this.discard();
                } else if (!(caster.getUseItem().getItem() instanceof SpatialDisorientationStaff)) {
                    this.discard();
                }
            }
        }
    }

    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void angleCircleAroundBlock(float circleDegrees, float groundDegrees, float distance, Vec3 pos) {
        double radius;
        double height = (double)distance * Math.cos(SpatialDisorientationMahoujinEntity.toRad(groundDegrees));
        if (height > (double)distance) {
            height = distance;
        }
        if (Double.isNaN(radius = Math.sqrt((double)(distance * distance) - height * height))) {
            radius = 0.0;
        }
        double zplus = radius * Math.sin(SpatialDisorientationMahoujinEntity.toRad(circleDegrees));
        double xplus = -radius * Math.cos(SpatialDisorientationMahoujinEntity.toRad(circleDegrees));
        this.setRotationPitch(groundDegrees);
        this.setRotationRoll(circleDegrees - 90.0f);
        this.setPos(pos.x + xplus, pos.y + height, pos.z + zplus);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public static double fromRad(double rad) {
        return rad * 57.2957795131;
    }

    public void sizer(float f) {
        this.setCircleSize(f);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.getInt(TAG_LIFE));
        this.setBeamSize(compound.getFloat(TAG_BEAM_SIZE));
        this.casterUUID = compound.getUUID(TAG_CASTER);
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setShootingTicks(compound.getInt(TAG_SHOOTING_TICKS));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putUUID(TAG_CASTER, this.casterUUID);
        compound.putFloat(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putInt(TAG_SHOOTING_TICKS, this.getShootingTicks());
        compound.putFloat(TAG_DISTANCE, this.getDistance());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public float getBeamSize() {
        return ((Float)this.entityData.get(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.entityData.set(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public int getShootingTicks() {
        return (Integer)this.entityData.get(SHOOTING_TICKS);
    }

    public void setShootingTicks(int t) {
        this.entityData.set(SHOOTING_TICKS, (Object)t);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }
}

