/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.fluids;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;
import stepsword.mahoutsukai.fluids.MurkyFluid;

public class FluidClientExtensions
implements IClientFluidTypeExtensions {
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.parse((String)"textures/misc/underwater.png");
    private static final ResourceLocation WATER_OVERLAY = ResourceLocation.parse((String)"block/water_overlay");

    public int getTintColor() {
        return -16759808;
    }

    public ResourceLocation getStillTexture() {
        return MurkyFluid.STILL;
    }

    public ResourceLocation getFlowingTexture() {
        return MurkyFluid.FLOW;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return WATER_OVERLAY;
    }

    @Nullable
    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
        return UNDERWATER_LOCATION;
    }

    public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter, (BlockPos)pos) | 0xFF000000;
    }
}

