/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.emrys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.entity.MahouLightningBoltEntity;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class StaffEmrys
extends ItemBase {
    public static HashMap<UUID, StaffEmrysUserStorage> staffs = new HashMap();

    public StaffEmrys() {
        super("staff_emrys", new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        staffs.remove(player.getUUID());
        if (handIn == InteractionHand.OFF_HAND) {
            player.startUsingItem(handIn);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(handIn));
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.getItemInHand(handIn));
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 72000;
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        StaffEmrysUserStorage storage;
        if (staffs.containsKey(player.getUUID())) {
            storage = staffs.get(player.getUUID());
        } else {
            storage = new StaffEmrysUserStorage(this);
            staffs.put(player.getUUID(), storage);
        }
        if (!player.level().isClientSide && player instanceof Player && PlayerManaManager.drainMana((Player)player, MTConfig.EMRYS_MANA_COST_FOCUSED / 20, false, false) == MTConfig.EMRYS_MANA_COST_FOCUSED / 20) {
            double d = 30.0;
            double addX = (double)((float)player.getRandom().nextInt((int)d) + player.getRandom().nextFloat()) - d / 2.0;
            double addZ = (double)((float)player.getRandom().nextInt((int)d) + player.getRandom().nextFloat()) - d / 2.0;
            double addY = player.getRandom().nextInt(2) - 2;
            int charge = this.getRemainingUseDuration(stack, player, count);
            ((ServerLevel)player.level()).rainLevel = Math.min((float)charge / 40.0f, 2.4f);
            ((ServerLevel)player.level()).thunderLevel = Math.min((float)charge / 40.0f, 2.4f);
            if ((float)charge / 15.0f > 2.4f) {
                if (player.getRandom().nextFloat() < 0.2f) {
                    int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, (int)(player.getX() + addX), (int)(player.getZ() + addZ));
                    StaffEmrys.addLightningBolt((ServerLevel)player.level(), new MahouLightningBoltEntity(player.level(), player.getX() + addX, y, player.getZ() + addZ, false));
                }
                boolean ball = true;
                if (storage.lightnings != null) {
                    for (int i = 0; i < storage.lightnings.size(); ++i) {
                        if (storage.lightnings.get(i).isAlive() && ball) {
                            storage.lightnings.get(i).setHasBall(ball);
                            ball = false;
                            continue;
                        }
                        storage.lightnings.get(i).setHasBall(false);
                    }
                }
                if (ServerHandler.tickCounter % 10L == 0L) {
                    float radius = MTConfig.EMRYS_MAX_RANGE;
                    AABB aabb = new AABB(player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius, player.getX() + (double)radius, player.getY() + (double)(radius * 2.0f), player.getZ() + (double)radius);
                    List lst = player.level().getEntitiesOfClass(LivingEntity.class, aabb);
                    Vec3 myloc = player.position();
                    lst.sort((e1, e2) -> (int)(e1.position().distanceToSqr(myloc) - e2.position().distanceToSqr(myloc)));
                    storage.lightnings.removeIf(a -> !a.isAlive());
                    storage.connected = new HashSet();
                    storage.lightnings.forEach(a -> {
                        if (a != null && a.target != null) {
                            storage.connected.add(a.target.getUUID());
                        }
                    });
                    for (LivingEntity e : lst) {
                        if (storage.lightnings.size() >= 3) break;
                        if (e.getUUID().equals(player.getUUID()) || storage.connected.contains(e.getUUID()) || ContractMahoujinTileEntity.isImmuneToSpell(player.level(), player.getUUID(), (Entity)e) || !this.validTarget(player, e)) continue;
                        LightningEntity le = new LightningEntity(player.level(), player, e, 1.0f, 1.0f, 1.0f, 1.0f, 0.02f, false);
                        player.level().addFreshEntity((Entity)le);
                        storage.lightnings.add(le);
                    }
                    if (storage.lightnings != null) {
                        for (int i = 0; i < storage.lightnings.size(); ++i) {
                            if (i == 0) {
                                storage.lightnings.get(i).setHasBall(true);
                                continue;
                            }
                            storage.lightnings.get(i).setHasBall(false);
                        }
                    }
                }
            }
        }
    }

    public boolean validTarget(LivingEntity caster, LivingEntity target) {
        if (!target.isAlive()) {
            return false;
        }
        boolean inrange = EffectUtil.inRange(target, caster, caster.position(), MTConfig.EMRYS_MAX_RANGE, false);
        if (inrange) {
            Vec3 targetEye = target.getEyePosition(1.0f);
            Vec3 casterEye = caster.getEyePosition(1.0f);
            Vec3 diff = targetEye.subtract(casterEye);
            double len = diff.length();
            Vec3 dir = diff.normalize();
            int i = 0;
            while ((double)i < len) {
                BlockPos p = Utils.toBlockPos(casterEye.add(dir.scale((double)i)));
                if (!caster.level().isEmptyBlock(p)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity caster, int t) {
        if (caster != null) {
            StaffEmrysUserStorage storage;
            if (staffs.containsKey(caster.getUUID())) {
                storage = staffs.get(caster.getUUID());
            } else {
                storage = new StaffEmrysUserStorage(this);
                staffs.put(caster.getUUID(), storage);
            }
            if (!world.isClientSide) {
                Utils.schedule(world, () -> {
                    for (LightningEntity e : storage.lightnings) {
                        e.discard();
                    }
                    staffs.remove(caster.getUUID());
                });
            }
        }
        super.releaseUsing(stack, world, caster, t);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public static void addLightningBolt(ServerLevel world, MahouLightningBoltEntity entityIn) {
        world.addFreshEntity((Entity)entityIn);
    }

    public static void zap(LivingEntity e, boolean ignoreZapped, Player caster) {
        if (e != null && !e.level().isClientSide) {
            int radius = 4;
            AABB aabb = new AABB(e.getX() - (double)radius, e.getY() - (double)radius, e.getZ() - (double)radius, e.getX() + (double)radius, e.getY() + (double)radius, e.getZ() + (double)radius);
            List lst = e.level().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity target : lst) {
                if (EffectUtil.hasBuff(target, ModEffects.ZAP_COOLDOWN) && !ignoreZapped || target.getMainHandItem().getItem() == ModItems.emrysStaff.get() || target.getOffhandItem().getItem() == ModItems.emrysStaff.get() || caster == null || PlayerManaManager.drainMana(caster, MTConfig.EMRYS_MANA_COST_PASSIVE, false, false) != MTConfig.EMRYS_MANA_COST_PASSIVE) continue;
                target.level().addFreshEntity((Entity)new LightningEntity(e.level(), e, target, 1.0f, 1.0f, 1.0f, 1.0f, 0.01f, true));
            }
        }
    }

    public static void emrysHit(AttackEntityEvent event) {
        if (event.getEntity().getOffhandItem().getItem() == ModItems.emrysStaff.get() && !event.getEntity().level().isClientSide && event.getTarget() instanceof LivingEntity && event.getEntity() instanceof Player) {
            StaffEmrys.zap((LivingEntity)event.getTarget(), false, event.getEntity());
        }
    }

    public int getRemainingUseDuration(ItemStack stack, LivingEntity e, int charge) {
        return this.getUseDuration(stack, e) - charge;
    }

    public static void emrysLivingHurt(LivingIncomingDamageEvent event) {
        if (!event.getEntity().level().isClientSide) {
            if ((event.getEntity().getOffhandItem().getItem() == ModItems.emrysStaff.get() || event.getEntity().getMainHandItem().getItem() == ModItems.emrysStaff.get()) && Utils.damageSourceAny(event.getSource(), DamageTypes.LIGHTNING_BOLT)) {
                event.setAmount(0.0f);
            }
            if (event.getSource().getEntity() instanceof Player && ((LivingEntity)event.getSource().getEntity()).getOffhandItem().getItem() == ModItems.emrysStaff.get()) {
                StaffEmrys.zap(event.getEntity(), false, (Player)event.getSource().getEntity());
            }
        }
    }

    public static void emrysStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof Player && !event.getEntity().level().isClientSide && !MTConfig.DISABLE_EMRYS && ((LivingEntity)event.getEntity()).getOffhandItem().getItem() == Items.STICK && StrengtheningSpellEffect.getStrengthened(((LivingEntity)event.getEntity()).getOffhandItem()) > 0) {
            ItemStack emrys = new ItemStack((ItemLike)ModItems.emrysStaff.get());
            StaffEmrys.turnStickIntoItem((Player)event.getEntity(), emrys);
        }
    }

    public static void turnStickIntoItem(Player player, ItemStack change) {
        ItemStack stack;
        if (!player.getInventory().offhand.isEmpty() && (stack = (ItemStack)player.getInventory().offhand.getFirst()).getItem() == Items.STICK && StrengtheningSpellEffect.getStrengthened(stack) > 0) {
            player.getInventory().offhand.set(0, (Object)change);
            ((MahouTrigger)((Object)ModTriggers.EMRYS.get())).trigger((ServerPlayer)player);
        }
    }

    public class StaffEmrysUserStorage {
        public ArrayList<LightningEntity> lightnings = new ArrayList();
        public HashSet<UUID> connected = new HashSet();

        public StaffEmrysUserStorage(StaffEmrys this$0) {
        }
    }
}

