/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.TreasuryProjection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TreasuryProjectionGauntlet
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_TREASURY_MODE";

    public TreasuryProjectionGauntlet() {
        super("treasury_projection_gauntlet", new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isDiscrete()) {
            if (!world.isClientSide) {
                Utils.setMode(stack, (Utils.getMode(stack) + 1) % 3);
                int mode = Utils.getMode(stack);
                MutableComponent tt = mode == 0 ? Component.translatable((String)"mahoutsukai.treasurygauntlet.targeted") : (mode == 1 ? Component.translatable((String)"mahoutsukai.treasurygauntlet.chains") : Component.translatable((String)"mahoutsukai.treasurygauntlet.aoe"));
                player.displayClientMessage((Component)tt, true);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        block10: {
            int numValid;
            ArrayList<ItemStack> projectables;
            int mode;
            block11: {
                mode = Utils.getMode(stack);
                if (!(player instanceof Player) || player.level().isClientSide) break block10;
                projectables = this.getProjectables((Player)player);
                numValid = TreasuryProjectionGauntlet.countNonProjected(projectables, level);
                if (mode != 0) break block11;
                if (projectables.isEmpty()) break block10;
                int mana = MTConfig.TREASURY_PROJECTION_GAUNTLET_MANA_COST;
                ItemStack projectile = projectables.get(player.getRandom().nextInt(projectables.size()));
                int cooldown = (int)Math.max(MTConfig.TREASURY_PROJECTION_COOLDOWN_MIN, (double)MTConfig.TREASURY_PROJECTION_COOLDOWN - (double)numValid * MTConfig.TREASURY_PROJECTION_COOLDOWN_INCREASE_PER_SWORD);
                if (count % cooldown != cooldown / 2 || PlayerManaManager.drainMana((Player)player, mana, false, false) != mana) break block10;
                Vec3 v = this.findSpotToCast(player.level(), (Player)player);
                RandomSource random = player.getRandom();
                TreasuryProjectionGauntlet.shootWeaponAt(projectile, player.level(), v, player, random, (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, MTConfig.TREASURY_PROJECTION_SPEED - MTConfig.TREASURY_PROJECTION_SPEED_INCREASE_PER_SWORD * (double)numValid));
                break block10;
            }
            if (mode == 1) {
                int mana = MTConfig.TREASURY_PROJECTION_CHAINS_MANA_COST;
                int cooldown = MTConfig.TREASURY_PROJECTION_CHAINS_COOLDOWN;
                int cnt = MTConfig.TREASURY_PROJECTION_CHAINS_COUNT;
                if (count % cooldown == cooldown / 2 && count < this.getUseDuration(stack, player)) {
                    if (this.getUseDuration(stack, player) - count <= cooldown) {
                        this.chains((Player)player, true, cnt, mana);
                    } else if (count % 19 * cooldown == 0) {
                        this.chains((Player)player, true, cnt, mana);
                    } else {
                        this.chains((Player)player, false, 1, mana);
                    }
                }
            } else if (mode == 2 && projectables.size() > 0) {
                int mana = MTConfig.TREASURY_PROJECTION_AOE_MANA_COST;
                int cooldown = (int)Math.max(MTConfig.TREASURY_PROJECTION_COOLDOWN_MIN, (double)MTConfig.TREASURY_PROJECTION_AOE_COOLDOWN - (double)numValid * MTConfig.TREASURY_PROJECTION_COOLDOWN_INCREASE_PER_SWORD);
                if (count % cooldown == cooldown / 2 && PlayerManaManager.drainMana((Player)player, mana, false, false) == mana && projectables.size() > 0) {
                    int numSpawns = (int)Math.min(MTConfig.TREASURY_PROJECTION_AOE_MAX_SPAWNS, (double)numValid / MTConfig.TREASURY_PROJECTION_AOE_SWORDS_PER_SPAWN);
                    for (int i = 0; i < Math.max(1, numSpawns); ++i) {
                        ItemStack projectile = projectables.get(player.getRandom().nextInt(projectables.size()));
                        TreasuryProjectionGauntlet.behindShoot(projectile, player.level(), player, player.getRandom(), (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, MTConfig.TREASURY_PROJECTION_SPEED - MTConfig.TREASURY_PROJECTION_SPEED_INCREASE_PER_SWORD * (double)numValid));
                    }
                }
            }
        }
        super.onUseTick(level, player, stack, count);
    }

    public static int countNonProjected(ArrayList<ItemStack> lst, Level level) {
        int ret = 0;
        HashSet<String> seen = new HashSet<String>();
        if (lst != null) {
            for (ItemStack s : lst) {
                if (ProjectionSpellEffect.getProjected(s) || seen.contains(Utils.getRegistryName(s.getItem(), level))) continue;
                ++ret;
                seen.add(Utils.getRegistryName(s.getItem(), level));
            }
        }
        return ret;
    }

    protected boolean isArrow(ItemStack stack, Level level) {
        boolean sword;
        Item tmpi = stack.getItem();
        if (stack.isEmpty()) {
            return false;
        }
        List<? extends String> white = MTConfig.TREASURY_PROJECTION_WHITELIST;
        List<? extends String> black = MTConfig.TREASURY_PROJECTION_BLACKLIST;
        boolean allow_all = MTConfig.TREASURY_PROJECTION_ALLOW_ALL;
        boolean deny_all = MTConfig.TREASURY_PROJECTION_DENY_ALL;
        boolean bl = sword = tmpi instanceof SwordItem || tmpi instanceof DiggerItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof HoeItem || tmpi instanceof TridentItem || MahouTsukaiMod.jousting.treasuryProjection(tmpi);
        if (deny_all) {
            sword = false;
        }
        boolean inwhite = false;
        boolean inblack = false;
        inwhite = EffectUtil.inItemBlacklist(stack.getItem(), white, level);
        inblack = EffectUtil.inItemBlacklist(stack.getItem(), black, level);
        if (inblack) {
            return false;
        }
        return sword || inwhite || allow_all;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public Vec3 findSpotToCast(Level world, Player player) {
        Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
        Vec3 v = e instanceof LivingEntity ? e.position().add(0.0, (double)(e.getBbHeight() / 2.0f), 0.0) : this.getTargetBlock(player);
        return v;
    }

    public ArrayList<ItemStack> getProjectables(Player player) {
        ItemStack stack2;
        int j;
        int z;
        IItemHandler inv;
        ItemStack stack1;
        int i;
        int size = player.getInventory().items.size();
        ArrayList<ItemStack> projectables = new ArrayList<ItemStack>();
        if (!MTConfig.TREASURY_PROJECTION_ENDER_CHEST_ONLY) {
            for (i = 0; i < size; ++i) {
                stack1 = (ItemStack)player.getInventory().items.get(i);
                if (this.isArrow(stack1, player.level())) {
                    projectables.add(stack1);
                }
                if ((inv = Utils.getInventory(stack1)) == null) continue;
                z = inv.getSlots();
                for (j = 0; j < z; ++j) {
                    stack2 = inv.getStackInSlot(j);
                    if (!this.isArrow(stack2, player.level())) continue;
                    projectables.add(stack2);
                }
            }
        }
        for (i = 0; i < player.getEnderChestInventory().getContainerSize(); ++i) {
            stack1 = player.getEnderChestInventory().getItem(i);
            if (this.isArrow(stack1, player.level())) {
                projectables.add(stack1);
            }
            if ((inv = Utils.getInventory(stack1)) == null) continue;
            z = inv.getSlots();
            for (j = 0; j < z; ++j) {
                stack2 = inv.getStackInSlot(j);
                if (!this.isArrow(stack2, player.level())) continue;
                projectables.add(stack2);
            }
        }
        return projectables;
    }

    public Vec3 getTargetBlock(Player player) {
        Vec3 target;
        HitResult result = Utils.rayTraceEyes((LivingEntity)player, MTConfig.GLOBAL_LOOK_RANGE);
        Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
        if (result.getType() == HitResult.Type.BLOCK && e == null) {
            BlockHitResult br = (BlockHitResult)result;
            target = new Vec3((double)br.getBlockPos().getX() + 0.5, (double)br.getBlockPos().getY(), (double)br.getBlockPos().getZ() + 0.5).add(0.0, 1.0, 0.0);
        } else if (e != null) {
            target = e.getEyePosition(1.0f);
        } else {
            Vec3 v = player.getViewVector(0.0f);
            Vec3 v2 = new Vec3(v.x * (double)MTConfig.GLOBAL_LOOK_RANGE, v.y * (double)MTConfig.GLOBAL_LOOK_RANGE, v.z * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3 v3 = player.getEyePosition(1.0f).add(v2);
            while (Utils.isBlockAir(player.level(), Utils.toBlockPos(v3)) && v3.y > 0.0) {
                v3 = v3.add(new Vec3(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public static void shootWeaponAt(ItemStack stack, Level world, Vec3 pos, LivingEntity player, RandomSource random, float speed) {
        GateWeaponProjectileEntity weapon;
        int d = MTConfig.TREASURY_PROJECTION_DISTANCE;
        int d2 = MTConfig.TREASURY_PROJECTION_MIN_DISTANCE;
        int tries = 0;
        do {
            ++tries;
            int circleDegrees = random.nextInt(360);
            int groundDegrees = random.nextInt(70) + 20;
            int distance = random.nextInt(d2) + (d - d2);
            double height = (double)distance * Math.cos(EffectUtil.toRad(groundDegrees));
            double radius = Math.sqrt((double)(distance * distance) - height * height);
            double zplus = radius * Math.sin(EffectUtil.toRad(circleDegrees));
            double xplus = -radius * Math.cos(EffectUtil.toRad(circleDegrees));
            weapon = new GateWeaponProjectileEntity(world, pos.x + xplus, pos.y + height, pos.z + zplus, stack.copy(), (Entity)player, speed);
            List<Integer> settings = MahouSettings.getIntSettings((Player)player, MahouSettings.Spell.TREASURY_WEAPONS);
            weapon.setColor(Utils.colorConvert(settings.get(0)), Utils.colorConvert(settings.get(1)), Utils.colorConvert(settings.get(2)), 1.0f, 0.0f, 0.0f, 0.0f);
            weapon.xRot = groundDegrees;
            weapon.yRot = circleDegrees - 90;
            weapon.setOwner((Entity)player);
            Vec3 aim = weapon.position().subtract(pos);
            weapon.shoot(-aim.x, -aim.y, -aim.z, 3.0f, 4.0f);
        } while (!world.isEmptyBlock(Utils.toBlockPos(weapon.position())) && tries < 20);
        world.addFreshEntity((Entity)weapon);
        if (player instanceof ServerPlayer) {
            ((MahouTrigger)((Object)ModTriggers.TREASURY_PROJECTION.get())).trigger((ServerPlayer)player);
        }
    }

    public static void behindShoot(ItemStack stack, Level world, LivingEntity player, RandomSource random, float speed) {
        GateWeaponProjectileEntity weapon;
        int tries = 0;
        do {
            Vec3 playerpos;
            ++tries;
            float scale = player.getRandom().nextFloat() * 4.0f + 3.0f;
            float height = player.getRandom().nextFloat() * 3.0f + 1.0f;
            Vec3 look = player.getLookAngle();
            Vec3 playerperp = playerpos = player.position();
            playerperp = playerperp.add(look.normalize().scale(-3.0));
            playerperp = player.getRandom().nextBoolean() ? playerperp.add(Vec3.directionFromRotation((float)0.0f, (float)(player.yRot + 90.0f)).normalize().scale((double)player.getRandom().nextInt(4) - 0.3).scale(2.0)) : playerperp.add(Vec3.directionFromRotation((float)0.0f, (float)(player.yRot - 90.0f)).normalize().scale((double)player.getRandom().nextInt(4) - 0.3).scale(2.0));
            playerperp = playerperp.add(Vec3.directionFromRotation((float)(player.xRot - 90.0f), (float)player.yRot).normalize().scale((double)player.getRandom().nextInt(4) + 1.8).scale(2.0));
            weapon = new GateWeaponProjectileEntity(world, playerperp.x, playerperp.y, playerperp.z, stack.copy(), (Entity)player, speed);
            List<Integer> settings = MahouSettings.getIntSettings((Player)player, MahouSettings.Spell.TREASURY_WEAPONS);
            weapon.setColor(Utils.colorConvert(settings.get(0)), Utils.colorConvert(settings.get(1)), Utils.colorConvert(settings.get(2)), 1.0f, 0.0f, 0.0f, 0.0f);
            weapon.xRot = player.xRot;
            weapon.yRot = player.yRot;
            Vec3 pos = weapon.position().add(player.getLookAngle());
            weapon.setOwner((Entity)player);
            Vec3 aim = weapon.position().subtract(pos);
            weapon.shoot(-aim.x, -aim.y, -aim.z, 3.0f, 4.0f);
        } while (!world.isEmptyBlock(Utils.toBlockPos(weapon.position())) && tries < 20);
        world.addFreshEntity((Entity)weapon);
        if (player instanceof ServerPlayer) {
            ((MahouTrigger)((Object)ModTriggers.TREASURY_PROJECTION.get())).trigger((ServerPlayer)player);
        }
    }

    public void chains(Player player, boolean prison, int tospawn, int mana) {
        if (PlayerManaManager.drainMana(player, mana * tospawn, false, false) == mana * tospawn) {
            float w;
            float h;
            Vec3 v;
            Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON));
            boolean entity = false;
            if (e instanceof LivingEntity) {
                v = e.position();
                h = e.getBbHeight() + 2.0f;
                w = e.getBbWidth() + 1.5f;
                entity = true;
            } else {
                v = this.getTargetBlock(player);
                h = 5.0f;
                w = 3.0f;
            }
            if (prison) {
                int i;
                ArrayList<Integer> degreeList = new ArrayList<Integer>();
                for (i = 0; i < tospawn; ++i) {
                    int q = 360 / tospawn;
                    int init = q * i;
                    degreeList.add(init += player.getRandom().nextInt(q / 3) - q / 6);
                }
                for (i = 0; i < tospawn; ++i) {
                    if (i >= degreeList.size()) continue;
                    int circleDegrees = (Integer)degreeList.get(i);
                    double zplus = (double)w * Math.sin(EffectUtil.toRad(circleDegrees));
                    double xplus = (double)(-w) * Math.cos(EffectUtil.toRad(circleDegrees));
                    Vec3 chainpos = v.add(0.0, (double)h, 0.0).add(new Vec3(xplus, 0.0, zplus));
                    Vec3 aimTo = v.subtract(chainpos).normalize().add((double)(player.getRandom().nextFloat() * 2.0f - 1.0f), (double)player.getRandom().nextFloat() - 0.5, (double)(player.getRandom().nextFloat() * 2.0f - 1.0f)).normalize().scale(40.0);
                    BlockHitResult raytrace = player.level().clip(new ClipContext(chainpos, chainpos.add(aimTo), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
                    Vec3 pos = EffectUtil.fromBlockPos(raytrace.getBlockPos());
                    if (Utils.isBlockAir(player.level(), Utils.toBlockPos(pos))) continue;
                    List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.TREASURY_CHAINS);
                    GateChainEntity chain = new GateChainEntity(player.level(), Utils.colorConvert(settings.get(0)), Utils.colorConvert(settings.get(1)), Utils.colorConvert(settings.get(2)), 1.0f, chainpos, pos);
                    Vec3 aim = chain.position().subtract(pos);
                    chain.shoot(-aim.x, -aim.y, -aim.z);
                    chain.setCircleSize(1.0f);
                    player.level().playSound(null, Utils.toBlockPos(chain.position()), (SoundEvent)ModSounds.CHAINS.get(), SoundSource.NEUTRAL, (float)MTConfig.CHAIN_VOLUME, 1.2f);
                    player.level().addFreshEntity((Entity)chain);
                }
            } else if (entity) {
                int circleDegrees = player.getRandom().nextInt(360);
                double zplus = (double)w * Math.sin(EffectUtil.toRad(circleDegrees));
                double xplus = (double)(-w) * Math.cos(EffectUtil.toRad(circleDegrees));
                Vec3 chainpos = v.add(0.0, (double)h, 0.0).add(new Vec3(xplus, 0.0, zplus));
                List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.TREASURY_CHAINS);
                Vec3 pos = e.position();
                GateChainEntity chain = new GateChainEntity(player.level(), Utils.colorConvert(settings.get(0)), Utils.colorConvert(settings.get(1)), Utils.colorConvert(settings.get(2)), 1.0f, chainpos, pos);
                Vec3 aim = chain.position().subtract(pos);
                chain.shoot(-aim.x, -aim.y, -aim.z);
                chain.setCircleSize(1.0f);
                player.level().playSound(null, Utils.toBlockPos(chain.position()), (SoundEvent)ModSounds.CHAINS.get(), SoundSource.NEUTRAL, (float)MTConfig.CHAIN_VOLUME, 1.2f);
                player.level().addFreshEntity((Entity)chain);
            }
        }
    }
}

