/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.william;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.worldsave.FictionData;
import stepsword.mahoutsukai.item.william.DictionaryDownloader;
import stepsword.mahoutsukai.item.william.DictionarySearcher;

public class WrittenEvaluation {
    public static float plagiarismEvaluation(HashMap<String, Integer> newText, HashMap<String, Integer> oldText) {
        HashSet<String> keys = new HashSet<String>(newText.keySet());
        keys.addAll(oldText.keySet());
        double newWords = (double)(1.0f - (float)(keys.size() - newText.size()) / (float)keys.size()) * MTConfig.PLAGIARISM_NEW_WORD_WEIGHT;
        double similarWordCount = MTConfig.PLAGIARISM_SIMILAR_WORD_COUNT_WEIGHT;
        float common = 0.0f;
        float sumdiff = 0.0f;
        for (String k : keys) {
            if (!newText.containsKey(k) || !oldText.containsKey(k)) continue;
            int n = newText.get(k);
            int o = oldText.get(k);
            sumdiff += WrittenEvaluation.closeness(n, o);
            common += 1.0f;
        }
        if (common > 0.0f) {
            sumdiff /= common;
        }
        return (float)(newWords + (similarWordCount *= (double)(1.0f - sumdiff)));
    }

    public static int evaluateString(String s, ConcurrentHashMap<FictionData, UUID> existing) {
        BreakDown analysis = WrittenEvaluation.analysis(s);
        float plagiarism = 0.0f;
        for (FictionData other : existing.keySet()) {
            BreakDown a = WrittenEvaluation.analysis(other.text);
            float p = WrittenEvaluation.plagiarismEvaluation(analysis.countsOfWords, a.countsOfWords);
            if (!(plagiarism < p)) continue;
            plagiarism = p;
        }
        double bestScore = -2.147483648E9;
        double worstScore = 2.147483647E9;
        String bd = null;
        String wd = null;
        for (String dict : DictionaryDownloader.dictionaries.keySet()) {
            DictionarySearcher ds = DictionaryDownloader.dictionaries.get((Object)dict).dictionary;
            double cscore = WrittenEvaluation.characterScore(analysis, ds);
            double wscore = WrittenEvaluation.wordScore(analysis, ds);
            double pscore = WrittenEvaluation.punctuationScore(analysis, ds);
            double sscore = WrittenEvaluation.spaceScore(analysis, ds);
            double score = Math.abs(cscore) * MTConfig.CHARACTER_SCORE_FACTOR + Math.abs(wscore) * MTConfig.WORD_SCORE_FACTOR + Math.abs(pscore) * MTConfig.PUNCTUATION_SCORE_FACTOR + Math.abs(sscore) * MTConfig.SPACE_SCORE_FACTOR;
            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                MahouTsukaiMod.logger.debug("word score: {}", (Object)wscore);
                MahouTsukaiMod.logger.debug("char score: {}", (Object)cscore);
                MahouTsukaiMod.logger.debug("punctuation score: {}", (Object)pscore);
                MahouTsukaiMod.logger.debug("space score: {}", (Object)sscore);
                MahouTsukaiMod.logger.debug("weighted word score: {}", (Object)(Math.abs(wscore) * MTConfig.WORD_SCORE_FACTOR));
                MahouTsukaiMod.logger.debug("weighted char score: {}", (Object)(Math.abs(cscore) * MTConfig.CHARACTER_SCORE_FACTOR));
                MahouTsukaiMod.logger.debug("weighted punctuation score: {}", (Object)(Math.abs(pscore) * MTConfig.PUNCTUATION_SCORE_FACTOR));
                MahouTsukaiMod.logger.debug("weighted space score: {}", (Object)(Math.abs(sscore) * MTConfig.SPACE_SCORE_FACTOR));
            }
            if (cscore < 0.0 || wscore < 0.0) {
                score *= -1.0;
            }
            if (score > bestScore) {
                bestScore = score;
                bd = dict;
            }
            if (!(score < worstScore)) continue;
            worstScore = score;
            wd = dict;
        }
        double chosenScore = bestScore;
        MahouTsukaiMod.logger.debug("MahouTsukai fiction creation:");
        MahouTsukaiMod.logger.debug("Best Score: {}", (Object)bestScore);
        MahouTsukaiMod.logger.debug("Best Matching Dictionary: {}", bd);
        MahouTsukaiMod.logger.debug("Worst Score: {}", (Object)worstScore);
        MahouTsukaiMod.logger.debug("Plagiarism: {}", (Object)Float.valueOf(plagiarism));
        if ((double)plagiarism > MTConfig.ACCEPTABLE_PLAGIARISM) {
            plagiarism = 1.0f;
        }
        return (int)Math.floor(chosenScore * (double)plagiarism);
    }

    public static BreakDown analysis(String s) {
        HashMap<String, Integer> countsOfWords = new HashMap<String, Integer>();
        HashMap<Character, Integer> countsOfChars = new HashMap<Character, Integer>();
        HashMap<Character, Integer> countsOfSpaces = new HashMap<Character, Integer>();
        HashMap<Character, Integer> countsOfPuncts = new HashMap<Character, Integer>();
        StringBuilder currentWord = new StringBuilder();
        int ws = 0;
        int cs = 0;
        for (int p = 0; p < s.length(); ++p) {
            char c = s.charAt(p);
            if (Character.isWhitespace(c)) {
                String curr = currentWord.toString().toLowerCase();
                if (!(curr = WrittenEvaluation.trimPunct(curr)).isEmpty()) {
                    countsOfWords.put(curr, countsOfWords.getOrDefault(curr, 0) + 1);
                    ++ws;
                    currentWord = new StringBuilder();
                }
                countsOfSpaces.put(Character.valueOf(c), countsOfSpaces.getOrDefault(Character.valueOf(c), 0) + 1);
                continue;
            }
            boolean punct = WrittenEvaluation.isPunct(s.substring(p, p + 1));
            Character pct = Character.valueOf(s.charAt(p));
            if (!currentWord.isEmpty() || !punct) {
                currentWord.append(pct);
                ++cs;
                countsOfChars.put(Character.valueOf(c), countsOfChars.getOrDefault(Character.valueOf(c), 0) + 1);
            }
            if (!punct) continue;
            countsOfPuncts.put(pct, countsOfPuncts.getOrDefault(pct, 0) + 1);
        }
        BreakDown ret = new BreakDown();
        ret.countsOfChars = countsOfChars;
        ret.countsOfWords = countsOfWords;
        ret.countsOfPuncts = countsOfPuncts;
        ret.countsOfSpaces = countsOfSpaces;
        ret.charCount = cs;
        ret.wordCount = ws;
        return ret;
    }

    public static String trimPunct(String s) {
        int j;
        int i;
        for (i = 0; i < s.length() && WrittenEvaluation.isPunct(s.substring(i, i + 1)); ++i) {
        }
        for (j = s.length(); j > 0 && WrittenEvaluation.isPunct(s.substring(j - 1, j)); --j) {
        }
        return s.substring(i, j);
    }

    public static boolean isPunct(String s) {
        return Pattern.matches("[\\p{Punct}\\p{IsPunctuation}]", s);
    }

    public static boolean isSpace(Character c) {
        return Character.isWhitespace(c.charValue());
    }

    public static String getBookText(ItemStack stack) {
        if (stack.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            WrittenBookContent writtenbookcontent = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
            List filtered = writtenbookcontent.getPages(true);
            List notfiltered = writtenbookcontent.getPages(false);
            StringBuilder bookText = new StringBuilder();
            for (int m = 0; m < MTConfig.WILLIAM_MAX_PAGES && m < filtered.size(); ++m) {
                String s = ((Component)filtered.get(m)).getString();
                bookText.append(s).append("\n");
            }
            return bookText.toString();
        }
        return "";
    }

    public static float closeness(int a1, int a2) {
        return (float)Math.abs(a1 - a2) / (float)Math.max(a1, a2);
    }

    public static int characterScore(BreakDown b, DictionarySearcher dictionary) {
        int m = 0;
        for (Character c : b.countsOfChars.keySet()) {
            if (!WrittenEvaluation.isPunct("" + c)) {
                m += b.countsOfChars.get(c).intValue();
            }
            if (dictionary.analysis.containsKey(c)) {
                m = (int)((float)m + (1.0f - WrittenEvaluation.closeness(dictionary.analysis.get(c), b.countsOfChars.get(c))) * (float)MTConfig.CHARACTER_RATIO_POINTS);
                continue;
            }
            if (WrittenEvaluation.isPunct("" + c)) continue;
            m -= MTConfig.CHARACTER_RATIO_POINTS;
        }
        return m * b.countsOfChars.keySet().size();
    }

    public static int punctuationScore(BreakDown b, DictionarySearcher dictionary) {
        int m = 0;
        for (Character c : b.countsOfPuncts.keySet()) {
            if (!WrittenEvaluation.isPunct("" + c)) continue;
            m += MTConfig.PUNCTUATION_RATIO_POINTS;
        }
        return m;
    }

    public static int spaceScore(BreakDown b, DictionarySearcher dictionary) {
        int m = 0;
        for (Character c : b.countsOfSpaces.keySet()) {
            if (!WrittenEvaluation.isSpace(c)) continue;
            m += MTConfig.SPACE_RATIO_POINTS;
        }
        return m;
    }

    public static int wordScore(BreakDown b, DictionarySearcher dictionary) {
        int totalWords = 0;
        int realWordValue = 0;
        for (String s : b.countsOfWords.keySet()) {
            totalWords += b.countsOfWords.get(s).intValue();
            if (dictionary.isWord(s)) {
                realWordValue += MTConfig.REAL_WORD_POINTS * s.length();
                continue;
            }
            realWordValue -= MTConfig.REAL_WORD_POINTS * s.length();
        }
        return totalWords * b.countsOfWords.keySet().size() * realWordValue;
    }

    public static class BreakDown {
        HashMap<String, Integer> countsOfWords = new HashMap();
        HashMap<Character, Integer> countsOfChars = new HashMap();
        HashMap<Character, Integer> countsOfPuncts = new HashMap();
        HashMap<Character, Integer> countsOfSpaces = new HashMap();
        int wordCount = 0;
        int charCount = 0;
    }
}

