/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ProjectorRightClickPacket
implements CustomPacketPayload {
    ARMOR_ACTION action;
    BlockPos pos;
    public static final StreamCodec<ByteBuf, ProjectorRightClickPacket> STREAM_CODEC = new StreamCodec<ByteBuf, ProjectorRightClickPacket>(){

        public ProjectorRightClickPacket decode(ByteBuf buf) {
            ProjectorRightClickPacket packet = new ProjectorRightClickPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, ProjectorRightClickPacket packet) {
            packet.encode(buf);
        }
    };

    public ProjectorRightClickPacket() {
    }

    public ProjectorRightClickPacket(ARMOR_ACTION action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    public void decode(ByteBuf buf) {
        this.action = ARMOR_ACTION.values()[buf.readInt() % ARMOR_ACTION.values().length];
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.pos.getX());
        buf.writeInt(this.pos.getY());
        buf.writeInt(this.pos.getZ());
    }

    public static void handle(ProjectorRightClickPacket message, IPayloadContext context) {
        ServerPlayer sender = (ServerPlayer)context.player();
        Utils.schedule(sender.level(), () -> ProjectorRightClickPacket.modifyArmor(context, message));
    }

    public static void modifyArmor(IPayloadContext context, ProjectorRightClickPacket message) {
        Player player = context.player();
        BlockEntity te = player.level().getBlockEntity(message.pos);
        if (te instanceof MahoujinProjectorTileEntity && player.getMainHandItem().getItem() instanceof ArmorItem) {
            MahoujinProjectorEnchant.setProjectorNBT(player.getMainHandItem(), (MahoujinProjectorTileEntity)te, message.action);
        }
    }

    public CustomPacketPayload.Type<ProjectorRightClickPacket> type() {
        return MahouPackets.PROJECTOR_RIGHT_CLICK_TYPE;
    }

    public static enum ARMOR_ACTION {
        REPLACE,
        ADD,
        REMOVE;

    }
}

