/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.Codecs;

public class SparkExplosionPacket
implements CustomPacketPayload {
    public Vec3 pos;
    public List<Float> color;
    public static final StreamCodec<ByteBuf, SparkExplosionPacket> STREAM_CODEC = StreamCodec.composite(Codecs.VEC3_STREAM, p -> p.pos, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs.list()), p -> p.color, SparkExplosionPacket::new);

    public SparkExplosionPacket(Vec3 e, List<Float> b) {
        this.pos = e;
        this.color = b;
    }

    public static void handle(SparkExplosionPacket message, IPayloadContext context) {
        float[] cs = new float[8];
        for (int i = 0; i < 8; ++i) {
            cs[i] = message.color.get(i).floatValue();
        }
        ClientPacketHandler.sparkExplosion(message.pos, cs);
    }

    public CustomPacketPayload.Type<SparkExplosionPacket> type() {
        return MahouPackets.SPARK_EXPLOSION_TYPE;
    }
}

