/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.networking.MahouPackets;

public class SweepAttackPacket
implements CustomPacketPayload {
    public int entityId;
    public static final StreamCodec<ByteBuf, SweepAttackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.entityId, SweepAttackPacket::new);

    public SweepAttackPacket(Entity e) {
        this.entityId = e.getId();
    }

    public SweepAttackPacket(int i) {
        this.entityId = i;
    }

    public static void handle(SweepAttackPacket message, IPayloadContext context) {
        Player player = context.player();
        Level world = player.level();
        Entity e = world.getEntity(message.entityId);
        SweepAttackPacket.doAttack(player, e);
    }

    public static void doAttack(Player player, Entity entity) {
        if (entity != null && player != null) {
            ItemStack held = player.getMainHandItem();
            if (entity != player && entity instanceof LivingEntity && held != null && !held.isEmpty() && (held.getItem() instanceof Caliburn || held.getItem() instanceof Morgan) && entity.isAlive() && !GeasEffect.hasGeas(player, (LivingEntity)entity)) {
                player.attackStrengthTicker = 1000;
                player.attack(entity);
                held.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    public CustomPacketPayload.Type<SweepAttackPacket> type() {
        return MahouPackets.SWEEP_ATTACK_TYPE;
    }
}

