/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.block.BlackFireBlock;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.BlackFirePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ExtraPotionInterface;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BlackFlameEyesPotion
extends EyesPotion
implements ExtraPotionInterface {
    protected BlackFlameEyesPotion() {
        super(ModEffects.getColorNumber(116, 232, 0));
    }

    @Override
    public void onRemove(LivingEntity player, MobEffect effect) {
        if (effect instanceof BlackFlameEyesPotion && player instanceof Player) {
            IMahou mahou = Utils.getPlayerMahou((Player)player);
            mahou.setPlayerPrevYaw(0.0f);
            mahou.setPlayerPrevPitch(0.0f);
            mahou.setPlayerPrevEyePos(null);
        }
    }

    @Override
    public void onAdd(LivingEntity livingEntity, MobEffect effect) {
    }

    public static void blackFlameEyesPlayerTick(Player player) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BLACK_FLAME_EYES)) {
            Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
            if (e instanceof LivingEntity) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BLACK_BURNING, false, MTConfig.BLACK_FLAME_DEBUFF_TIME);
                BlackFlameEyesPotion.notifyIfBurning((LivingEntity)e);
            } else {
                float prevYaw = mahou.getPlayerPrevYaw();
                float prevPitch = mahou.getPlayerPrevPitch();
                Vec3 prevEye = mahou.getPlayerPrevEyePos();
                if (prevYaw == 0.0f) {
                    prevYaw = player.yRot;
                }
                if (prevPitch == 0.0f) {
                    prevPitch = player.xRot;
                }
                if (prevEye == null) {
                    prevEye = player.getEyePosition(1.0f);
                }
                float yawDistance = player.yRot - prevYaw;
                float pitchDistance = player.xRot - prevPitch;
                Vec3 eyeDistance = player.getEyePosition(1.0f).subtract(prevEye);
                for (int i = 1; i < 21; ++i) {
                    BlockHitResult result = BlackFlameEyesPotion.rayTrace(MTConfig.BLACK_FLAME_RANGE_FROM_USER, player, eyeDistance.scale((double)((float)i / 20.0f)).add(prevEye), yawDistance * (float)i / 20.0f + prevYaw, pitchDistance * (float)i / 20.0f + prevPitch);
                    if (result == null || result.getType() == HitResult.Type.MISS) continue;
                    BlockPos pos = result.getBlockPos();
                    Direction hit = result.getDirection();
                    if (!Utils.isBlockAir(player.level(), pos.relative(hit)) || player.level().getBlockState(pos).getBlock() == ModBlocks.blackFireBlock.get()) continue;
                    EffectUtil.tryChangeBlockState(false, pos.relative(hit), ((BlackFireBlock)((Object)ModBlocks.blackFireBlock.get())).defaultBlockState(), player.level(), player);
                }
                mahou.setPlayerPrevYaw(player.yRot);
                mahou.setPlayerPrevPitch(player.xRot);
                mahou.setPlayerPrevEyePos(player.getEyePosition(1.0f));
            }
        }
    }

    public static void blackFlameEyesLivingUpdate(LivingEntity entity) {
        if (entity != null && entity.isAlive() && !entity.level().isClientSide && ServerHandler.tickCounter % 20L == 0L && EffectUtil.hasBuff(entity, ModEffects.BLACK_BURNING)) {
            entity.hurt(entity.damageSources().wither(), (float)MTConfig.BLACK_FLAME_DAMAGE);
            entity.lastHurtByPlayerTime = 100;
        }
    }

    public static BlockHitResult rayTrace(double blockReachDistance, Player player, Vec3 v, float yaw, float pitch) {
        HitResult zz = player.pick(blockReachDistance, 1.0f, false);
        if (zz instanceof BlockHitResult) {
            return (BlockHitResult)zz;
        }
        return null;
    }

    public static void notifyIfBurning(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.BLACK_BURNING)) {
            BlackFlameEyesPotion.notifyTracking(lst, true, e.level());
        }
    }

    public static void notifyNotBurning(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        BlackFlameEyesPotion.notifyTracking(lst, false, e.level());
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new BlackFirePacket(e.getId(), r));
            }
        }
    }
}

