/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.networking.InsightPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class InsightEyesPotion
extends EyesPotion {
    public static Map<Player, Boolean> hadTargets = new HashMap<Player, Boolean>();

    protected InsightEyesPotion() {
        super(ModEffects.getColorNumber(204, 204, 140));
    }

    public static void insightEyesPlayerTick(Player player) {
        if (!player.level().isClientSide && EffectUtil.hasBuff((LivingEntity)player, ModEffects.INSIGHT)) {
            Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.INSIGHT, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.INSIGHT));
            HitResult result = Utils.rayTraceEyes((LivingEntity)player, MTConfig.GLOBAL_LOOK_RANGE);
            if (e != null && result instanceof BlockHitResult) {
                double d2;
                double d1 = player.position().distanceToSqr(e.position());
                if (d1 > (d2 = player.position().distanceToSqr(EffectUtil.fromBlockPos(((BlockHitResult)result).getBlockPos()))) || !(e instanceof LivingEntity)) {
                    e = null;
                } else {
                    result = null;
                }
            }
            if (e != null && e instanceof LivingEntity) {
                IItemHandler inventory = Utils.getInventory((LivingEntity)e);
                ItemStack s = ((LivingEntity)e).getMainHandItem();
                int indexmain = -1;
                int r = 0;
                if (inventory != null) {
                    for (int z = 0; z < inventory.getSlots(); ++z) {
                        if (inventory.getStackInSlot(z).isEmpty()) continue;
                        if (inventory.getStackInSlot(z).equals(s)) {
                            indexmain = r;
                        }
                        ++r;
                    }
                }
                PacketHandler.sendTo((ServerPlayer)player, new InsightPacket(InsightEyesPotion.writeInventory(inventory, player.level()), InsightEyesPotion.writeEffects(((LivingEntity)e).getActiveEffects()), true, false, e.getId(), indexmain));
                hadTargets.put(player, true);
                return;
            }
            if (result instanceof BlockHitResult) {
                BlockPos pos = ((BlockHitResult)result).getBlockPos();
                IItemHandler inventory = Utils.getInventory(player.level(), pos);
                if (inventory != null) {
                    PacketHandler.sendTo((ServerPlayer)player, new InsightPacket(InsightEyesPotion.writeInventory(inventory, player.level()), InsightEyesPotion.writeEffects(null), true, true, -1, -1));
                    hadTargets.put(player, true);
                    return;
                }
            }
        }
        if (hadTargets.containsKey(player) && hadTargets.get(player).booleanValue()) {
            hadTargets.remove(player);
            PacketHandler.sendTo((ServerPlayer)player, new InsightPacket(InsightEyesPotion.writeInventory(null, player.level()), InsightEyesPotion.writeEffects(null), false, false, -1, -1));
        }
    }

    public static CompoundTag writeInventory(IItemHandler inventory, Level level) {
        CompoundTag list = new CompoundTag();
        int m = 0;
        if (inventory != null) {
            for (int i = 0; i < Math.min(54, inventory.getSlots()); ++i) {
                CompoundTag tag = new CompoundTag();
                if (inventory.getStackInSlot(i).isEmpty()) continue;
                tag = (CompoundTag)inventory.getStackInSlot(i).save((HolderLookup.Provider)level.registryAccess());
                list.put("index" + m++, (Tag)tag);
            }
        }
        return list;
    }

    public static ArrayList<ItemStack> readInventory(CompoundTag nbt, Level level) {
        ArrayList<ItemStack> lst = new ArrayList<ItemStack>();
        int i = 0;
        while (nbt.contains("index" + i)) {
            CompoundTag item;
            if ((item = (CompoundTag)nbt.get("index" + i++)) == null) continue;
            Optional stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)item);
            stack.ifPresent(s -> lst.add((ItemStack)stack.get()));
        }
        return lst;
    }

    public static CompoundTag writeEffects(Collection<MobEffectInstance> es) {
        CompoundTag ret = new CompoundTag();
        if (es != null) {
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(es);
            int m = 0;
            for (int i = 0; i < effects.size(); ++i) {
                CompoundTag tag = new CompoundTag();
                if (effects.get(i).getDuration() <= 0) continue;
                tag = (CompoundTag)effects.get(i).save();
                ret.put("effect" + m++, (Tag)tag);
            }
        }
        return ret;
    }

    public static ArrayList<MobEffectInstance> readEffects(CompoundTag nbt) {
        ArrayList<MobEffectInstance> lst = new ArrayList<MobEffectInstance>();
        int i = 0;
        while (nbt.contains("effect" + i)) {
            CompoundTag effecttag;
            if ((effecttag = (CompoundTag)nbt.get("effect" + i++)) == null) continue;
            MobEffectInstance effect = MobEffectInstance.load((CompoundTag)effecttag);
            lst.add(effect);
        }
        return lst;
    }
}

