/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.enchant;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import stepsword.mahoutsukai.config.MTConfig;

public class ProjectorValues {
    public float csize = 1.0f;
    public int cr = 255;
    public int cg = 255;
    public int cb = 20;
    public int ca = 200;
    public float cx = 0.0f;
    public float cy = 0.0f;
    public float cz = 0.0f;
    public float cspeed = (float)MTConfig.PROJECTOR_DEFAULT_ROTATION_SPEED;
    public float cyawspeed = 0.0f;
    public float cpitspeed = 0.0f;
    public float cpitch = 0.0f;
    public float cyaw = 0.0f;
    public float crotation = 0.0f;
    public float cringangle = 0.0f;
    public float cpreyaw = 0.0f;
    public float cprepitch = 0.0f;
    public float corbitspeed = 0.0f;
    public float corbit = 0.0f;
    public float gif_frame = 0.0f;
    public float gif_speed = 1.0f;
    public boolean gif_layer = false;
    public boolean showCircle = true;
    public boolean showRing = true;
    public float height = 0.125f;
    public float rotationoffset = 0.0f;
    public int image = -1;
    public int runes = -1;
    public static final String csizeTAG = "CIRCLE_SIZE";
    public static final String crTAG = "CIRCLE_R";
    public static final String cgTAG = "CIRCLE_G";
    public static final String cbTAG = "CIRCLE_B";
    public static final String caTAG = "CIRCLE_A";
    public static final String cxTAG = "CIRCLE_X";
    public static final String cyTAG = "CIRCLE_Y";
    public static final String czTAG = "CIRCLE_Z";
    public static final String cspeedTAG = "CIRCLE_SPEED";
    public static final String cyspeedTAG = "CIRCLE_SPEED_YAW";
    public static final String cpspeedTAG = "CIRCLE_SPEED_PITCH";
    public static final String cpitchTAG = "CIRCLE_PITCH";
    public static final String cyawTAG = "CIRCLE_YAW";
    public static final String crotationTAG = "CIRCLE_ROTATION";
    public static final String cringangleTAG = "CIRCLE_RING_ANGLE";
    public static final String cpreyawTAG = "CIRCLE_PRE_YAW";
    public static final String cprepitchTAG = "CIRCLE_PRE_PITCH";
    public static final String corbitspeedTAG = "CIRCLE_ORBIT_SPEED";
    public static final String corbitTAG = "CIRCLE_ORBIT";
    public static final String showCircleTAG = "CIRCLE_SHOW_C";
    public static final String showRingTAG = "CIRCLE_SHOW_R";
    public static final String imageTAG = "IMAGE_LOAD";
    public static final String runesTAG = "RUNES_LOAD";
    public static final String heightTAG = "RING_HEIGHT";
    public static final String rotationOffsetTAG = "ROTATION_OFFSET";
    public static final String gifSpeedTAG = "GIF_SPEED";
    public static final String gifLayerTag = "GIF_LAYER";

    public ProjectorValues() {
    }

    public ProjectorValues(List<Integer> ints, List<Float> floats, List<Boolean> bools) {
        this.setAllFloats(new ArrayList<Float>(floats));
        this.setAllInts(new ArrayList<Integer>(ints));
        this.setAllBools(new ArrayList<Boolean>(bools));
    }

    public CompoundTag write(CompoundTag compound) {
        compound.putFloat(csizeTAG, this.csize);
        compound.putInt(crTAG, this.cr);
        compound.putInt(cgTAG, this.cg);
        compound.putInt(cbTAG, this.cb);
        compound.putInt(caTAG, this.ca);
        compound.putFloat(cxTAG, this.cx);
        compound.putFloat(cyTAG, this.cy);
        compound.putFloat(czTAG, this.cz);
        compound.putFloat(cspeedTAG, this.cspeed);
        compound.putFloat(cpspeedTAG, this.cpitspeed);
        compound.putFloat(cyspeedTAG, this.cyawspeed);
        compound.putFloat(cyawTAG, this.cyaw);
        compound.putFloat(cpitchTAG, this.cpitch);
        compound.putFloat(crotationTAG, this.crotation);
        compound.putFloat(cringangleTAG, this.cringangle);
        compound.putFloat(cprepitchTAG, this.cprepitch);
        compound.putFloat(cpreyawTAG, this.cpreyaw);
        compound.putFloat(corbitspeedTAG, this.corbitspeed);
        compound.putFloat(corbitTAG, this.corbit);
        compound.putBoolean(showCircleTAG, this.showCircle);
        compound.putBoolean(showRingTAG, this.showRing);
        compound.putInt(imageTAG, this.image);
        compound.putInt(runesTAG, this.runes);
        compound.putFloat(heightTAG, this.height);
        compound.putFloat(rotationOffsetTAG, this.rotationoffset);
        compound.putFloat(gifSpeedTAG, this.gif_speed);
        compound.putBoolean(gifLayerTag, this.gif_layer);
        return compound;
    }

    public void read(CompoundTag compound) {
        this.csize = compound.getFloat(csizeTAG);
        this.cr = compound.getInt(crTAG);
        this.cg = compound.getInt(cgTAG);
        this.cb = compound.getInt(cbTAG);
        this.ca = compound.getInt(caTAG);
        this.cx = compound.getFloat(cxTAG);
        this.cy = compound.getFloat(cyTAG);
        this.cz = compound.getFloat(czTAG);
        this.cspeed = compound.getFloat(cspeedTAG);
        this.cyawspeed = compound.getFloat(cyspeedTAG);
        this.cpitspeed = compound.getFloat(cpspeedTAG);
        this.cpitch = compound.getFloat(cpitchTAG);
        this.cyaw = compound.getFloat(cyawTAG);
        this.crotation = compound.getFloat(crotationTAG);
        this.cringangle = compound.getFloat(cringangleTAG);
        this.showCircle = compound.getBoolean(showCircleTAG);
        this.showRing = compound.getBoolean(showRingTAG);
        this.image = compound.getInt(imageTAG);
        this.runes = compound.getInt(runesTAG);
        this.height = compound.getFloat(heightTAG);
        this.rotationoffset = compound.getFloat(rotationOffsetTAG);
        this.cprepitch = compound.getFloat(cprepitchTAG);
        this.cpreyaw = compound.getFloat(cpreyawTAG);
        this.corbitspeed = compound.getFloat(corbitspeedTAG);
        this.gif_speed = compound.getFloat(gifSpeedTAG);
        this.gif_layer = compound.getBoolean(gifLayerTag);
    }

    public float getCsize() {
        return this.csize;
    }

    public int getCr() {
        return this.cr;
    }

    public int getCg() {
        return this.cg;
    }

    public int getCb() {
        return this.cb;
    }

    public int getCa() {
        return this.ca;
    }

    public float getCx() {
        return this.cx;
    }

    public float getCy() {
        return this.cy;
    }

    public float getCz() {
        return this.cz;
    }

    public float getCpitch() {
        return this.cpitch;
    }

    public float getCyspeed() {
        return this.cyawspeed;
    }

    public float getCpspeed() {
        return this.cpitspeed;
    }

    public float getCspeed() {
        return this.cspeed;
    }

    public float getCyaw() {
        return this.cyaw;
    }

    public float getCringangle() {
        return this.cringangle;
    }

    public float getRotation() {
        return this.crotation;
    }

    public boolean getShowCircle() {
        return this.showCircle;
    }

    public boolean getShowRing() {
        return this.showRing;
    }

    public int getImage() {
        return this.image;
    }

    public int getRunes() {
        return this.runes;
    }

    public float getHeight() {
        return this.height;
    }

    public float getRotationOffset() {
        return this.rotationoffset;
    }

    public float getCorbitspeed() {
        return this.corbitspeed;
    }

    public float getCprepitch() {
        return this.cprepitch;
    }

    public float getCpreyaw() {
        return this.cpreyaw;
    }

    public float getGifSpeed() {
        return this.gif_speed;
    }

    public boolean getGifLayer() {
        return this.gif_layer;
    }

    public ArrayList<Float> getAllFloats() {
        return new ArrayList<Float>(Arrays.asList(Float.valueOf(this.cx), Float.valueOf(this.cy), Float.valueOf(this.cz), Float.valueOf(this.csize), Float.valueOf(this.cspeed), Float.valueOf(this.cyaw), Float.valueOf(this.cpitch), Float.valueOf(this.cringangle), Float.valueOf(this.height), Float.valueOf(this.rotationoffset), Float.valueOf(this.cyawspeed), Float.valueOf(this.cpitspeed), Float.valueOf(this.corbitspeed), Float.valueOf(this.cpreyaw), Float.valueOf(this.cprepitch), Float.valueOf(this.gif_speed)));
    }

    public void setAllFloats(ArrayList<Float> floats) {
        this.cx = floats.get(0).floatValue();
        this.cy = floats.get(1).floatValue();
        this.cz = floats.get(2).floatValue();
        this.csize = floats.get(3).floatValue();
        this.cspeed = floats.get(4).floatValue();
        this.cyaw = floats.get(5).floatValue();
        this.cpitch = floats.get(6).floatValue();
        this.cringangle = floats.get(7).floatValue();
        this.height = floats.get(8).floatValue();
        this.rotationoffset = floats.get(9).floatValue();
        this.cyawspeed = floats.get(10).floatValue();
        this.cpitspeed = floats.get(11).floatValue();
        this.corbitspeed = floats.get(12).floatValue();
        this.cpreyaw = floats.get(13).floatValue();
        this.cprepitch = floats.get(14).floatValue();
        this.gif_speed = floats.get(15).floatValue();
    }

    public ArrayList<Integer> getAllInts() {
        return new ArrayList<Integer>(Arrays.asList(this.cr, this.cg, this.cb, this.ca, this.image, this.runes));
    }

    public void setAllInts(ArrayList<Integer> ints) {
        this.cr = ints.get(0);
        this.cg = ints.get(1);
        this.cb = ints.get(2);
        this.ca = ints.get(3);
        this.image = ints.get(4);
        this.runes = ints.get(5);
    }

    public ArrayList<Boolean> getAllBools() {
        return new ArrayList<Boolean>(Arrays.asList(this.showCircle, this.showRing, this.gif_layer));
    }

    public void setAllBools(ArrayList<Boolean> ints) {
        this.showCircle = ints.get(0);
        this.showRing = ints.get(1);
        this.gif_layer = ints.get(2);
    }

    public void decode(ByteBuf buf) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ArrayList<Float> floats = new ArrayList<Float>();
        ArrayList<Boolean> bools = new ArrayList<Boolean>();
        int sz = buf.readInt();
        for (int m = 0; m < sz; ++m) {
            ints.add(buf.readInt());
        }
        int sz2 = buf.readInt();
        for (int m = 0; m < sz2; ++m) {
            floats.add(Float.valueOf(buf.readFloat()));
        }
        int sz3 = buf.readInt();
        for (int m = 0; m < sz3; ++m) {
            bools.add(buf.readBoolean());
        }
        this.setAllBools(bools);
        this.setAllFloats(floats);
        this.setAllInts(ints);
    }

    public void encode(ByteBuf buf) {
        int m;
        ArrayList<Integer> ints = this.getAllInts();
        ArrayList<Float> floats = this.getAllFloats();
        ArrayList<Boolean> bools = this.getAllBools();
        buf.writeInt(ints.size());
        for (m = 0; m < ints.size(); ++m) {
            buf.writeInt(ints.get(m).intValue());
        }
        buf.writeInt(floats.size());
        for (m = 0; m < floats.size(); ++m) {
            buf.writeFloat(floats.get(m).floatValue());
        }
        buf.writeInt(bools.size());
        for (m = 0; m < bools.size(); ++m) {
            buf.writeBoolean(bools.get(m).booleanValue());
        }
    }

    public int hashCode() {
        return 13 * this.getAllInts().hashCode() + 11 * this.getAllBools().hashCode() + 7 * this.getAllFloats().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectorValues) {
            ProjectorValues b = (ProjectorValues)obj;
            return b.getAllFloats().equals(this.getAllFloats()) && b.getAllBools().equals(this.getAllBools()) && b.getAllInts().equals(this.getAllInts());
        }
        return false;
    }
}

