/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity.familiar;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.render.entity.familiar.ModelFamiliar;

public class RenderFamiliarEntity
extends MobRenderer<FamiliarEntity, ModelFamiliar> {
    static ResourceLocation t1 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/item/familiar-texture1.png");
    static ResourceLocation t2 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/item/familiar-texture2.png");

    public RenderFamiliarEntity(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelFamiliar(), 0.3f);
    }

    public ResourceLocation getTextureLocation(FamiliarEntity entity) {
        return t2;
    }

    public float getBob(FamiliarEntity livingBase, float partialTicks) {
        return this.getCustomBob(livingBase, partialTicks);
    }

    private float getCustomBob(FamiliarEntity parrot, float p_192861_2_) {
        float f = parrot.oFlap + (parrot.flap - parrot.oFlap) * p_192861_2_;
        float f1 = parrot.oFlapSpeed + (parrot.flapSpeed - parrot.oFlapSpeed) * p_192861_2_;
        return (Mth.sin((float)f) + 1.0f) * f1;
    }

    public void render(FamiliarEntity entityIn, float yaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        boolean shouldSit;
        if (((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn))).isCanceled()) {
            return;
        }
        matrixStackIn.pushPose();
        ((ModelFamiliar)this.model).attackTime = this.getAttackAnim((LivingEntity)entityIn, partialTicks);
        ((ModelFamiliar)this.model).riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        ((ModelFamiliar)this.model).young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && entityIn.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.getVehicle();
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.xRot);
        if (entityIn.getPose() == Pose.SLEEPING && (direction = entityIn.getBedOrientation()) != null) {
            float f4 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = this.getBob(entityIn, partialTicks);
        this.setupRotations((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks, 1.0f);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entityIn, matrixStackIn, partialTicks);
        matrixStackIn.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.speed();
            f5 = entityIn.walkAnimation.position();
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((ModelFamiliar)this.model).prepareMobModel(entityIn, f5, f8, partialTicks);
        ((ModelFamiliar)this.model).setupAnim(entityIn, f5, f8, f7, f2, f6);
        boolean flag = this.isBodyVisible((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)Minecraft.getInstance().player);
        int i = RenderFamiliarEntity.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress((LivingEntity)entityIn, partialTicks));
        float[] rgb = entityIn.getColor();
        ((ModelFamiliar)this.model).render(matrixStackIn, bufferIn, packedLightIn, i, rgb[0], rgb[1], rgb[2], flag1 ? 0.15f : 1.0f);
        for (RenderLayer renderlayer : this.layers) {
            renderlayer.render(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
        }
        matrixStackIn.popPose();
        RenderNameTagEvent renderNameplateEvent = new RenderNameTagEvent((Entity)entityIn, entityIn.getDisplayName(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        NeoForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.canRender() == TriState.TRUE || this.shouldShowName(entityIn)) {
            this.renderNameTag((Entity)entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn, partialTicks);
        }
        NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
        super.render((LivingEntity)entityIn, yaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean shouldShowName(FamiliarEntity entity) {
        return super.shouldShowName((Mob)entity) && (entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity);
    }
}

