/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderBlackBurning {
    static ResourceLocation burn0 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"block/black_fire_layer_0");
    static ResourceLocation burn1 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"block/black_fire_layer_1");
    static Material m0 = new Material(TextureAtlas.LOCATION_BLOCKS, burn0);
    static Material m1 = new Material(TextureAtlas.LOCATION_BLOCKS, burn1);

    public static void renderEntityFire(LivingEntity entity, PoseStack matrix, MultiBufferSource buffer, float partialTicks, LivingEntityRenderer renderer) {
        if (EffectUtil.hasBuff(entity, ModEffects.BLACK_BURNING)) {
            RenderBlackBurning.renderFire(matrix, buffer, (Entity)entity);
        }
    }

    private static void renderFire(PoseStack matrixStackIn, MultiBufferSource bufferIn, Entity entityIn) {
        TextureAtlasSprite textureatlassprite = m0.sprite();
        TextureAtlasSprite textureatlassprite1 = m1.sprite();
        matrixStackIn.pushPose();
        float f = entityIn.getBbWidth() * 1.4f;
        matrixStackIn.scale(f, f, f);
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = entityIn.getBbHeight() / f;
        float f4 = 0.0f;
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-Minecraft.getInstance().getEntityRenderDispatcher().camera.getYRot()));
        matrixStackIn.translate(0.0, 0.0, (double)(-0.3f + (float)((int)f3) * 0.02f));
        float f5 = 0.0f;
        int i = 0;
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(Sheets.cutoutBlockSheet());
        PoseStack.Pose matrixstack$entry = matrixStackIn.last();
        while (f3 > 0.0f) {
            TextureAtlasSprite textureatlassprite2 = i % 2 == 0 ? textureatlassprite : textureatlassprite1;
            float f6 = textureatlassprite2.getU0();
            float f7 = textureatlassprite2.getV0();
            float f8 = textureatlassprite2.getU1();
            float f9 = textureatlassprite2.getV1();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            RenderBlackBurning.fireVertex(matrixstack$entry, ivertexbuilder, f1 - 0.0f, 0.0f - f4, f5, f8, f9);
            RenderBlackBurning.fireVertex(matrixstack$entry, ivertexbuilder, -f1 - 0.0f, 0.0f - f4, f5, f6, f9);
            RenderBlackBurning.fireVertex(matrixstack$entry, ivertexbuilder, -f1 - 0.0f, 1.4f - f4, f5, f6, f7);
            RenderBlackBurning.fireVertex(matrixstack$entry, ivertexbuilder, f1 - 0.0f, 1.4f - f4, f5, f8, f7);
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i;
        }
        matrixStackIn.popPose();
    }

    private static void fireVertex(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, float x, float y, float z, float texU, float texV) {
        bufferIn.addVertex(matrixEntryIn.pose(), x, y, z).setColor(255, 255, 255, 255).setUv(texU, texV).setUv1(0, 10).setUv2(240, 240).setNormal(0.0f, 1.0f, 0.0f);
    }

    public static void renderOverlayFire(PoseStack matrix, float partialTicks) {
        boolean flag;
        Minecraft mc = Minecraft.getInstance();
        boolean bl = flag = mc.getCameraEntity() instanceof LivingEntity && ((LivingEntity)mc.getCameraEntity()).isSleeping();
        if (mc.options.getCameraType().isFirstPerson() && !flag && EffectUtil.hasBuff((LivingEntity)mc.player, ModEffects.BLACK_BURNING)) {
            RenderBlackBurning.renderFire(mc, matrix);
            RenderBlackBurning.hurtCameraEffect(matrix, partialTicks);
        }
    }

    private static void hurtCameraEffect(PoseStack matrixStackIn, float partialTicks) {
        if (Minecraft.getInstance().getCameraEntity() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)Minecraft.getInstance().getCameraEntity();
            float f = (float)livingentity.hurtTime - partialTicks;
            if (livingentity.getHealth() <= 0.0f) {
                float f1 = Math.min((float)livingentity.deathTime + partialTicks, 20.0f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(40.0f - 8000.0f / (f1 + 200.0f)));
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)livingentity.hurtDuration;
            f = Mth.sin((float)(f * f * f * f * (float)Math.PI));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-f * 14.0f));
        }
    }

    private static void renderFire(Minecraft minecraftIn, PoseStack matrixStackIn) {
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (!RenderUtils.turnOffMahouShaders()) {
            RenderSystem.setShader(() -> ModShaders.FULLBRIGHT_QUADS);
        }
        TextureAtlasSprite textureatlassprite = m1.sprite();
        RenderUtils.bindTexture(textureatlassprite.atlasLocation());
        float f = textureatlassprite.getU0();
        float f1 = textureatlassprite.getU1();
        float f2 = (f + f1) / 2.0f;
        float f3 = textureatlassprite.getV0();
        float f4 = textureatlassprite.getV1();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = textureatlassprite.uvShrinkRatio();
        float f7 = Mth.lerp((float)f6, (float)f, (float)f2);
        float f8 = Mth.lerp((float)f6, (float)f1, (float)f2);
        float f9 = Mth.lerp((float)f6, (float)f3, (float)f5);
        float f10 = Mth.lerp((float)f6, (float)f4, (float)f5);
        float f11 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            matrixStackIn.pushPose();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            matrixStackIn.translate((double)((float)(-(i * 2 - 1)) * 0.24f), (double)-0.3f, 0.0);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = matrixStackIn.last().pose();
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.addVertex(matrix4f, -0.5f, -0.5f, -0.5f).setUv(f8, f10).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferbuilder.addVertex(matrix4f, 0.5f, -0.5f, -0.5f).setUv(f7, f10).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferbuilder.addVertex(matrix4f, 0.5f, 0.5f, -0.5f).setUv(f7, f9).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferbuilder.addVertex(matrix4f, -0.5f, 0.5f, -0.5f).setUv(f8, f9).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            matrixStackIn.popPose();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
    }
}

