/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderInsightOverlay {
    public static ArrayList<ItemStack> inventory = new ArrayList();
    public static ArrayList<MobEffectInstance> effects = new ArrayList();
    public static int mainhandindex = -1;
    public static ResourceLocation insight = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/gui/insight.png");
    public static int invprogress = 0;
    public static int maxinvprogress = 10;
    public static int effectsprogress = 0;
    public static int maxeffectsprogress = 10;
    public static int mainhandprogress = 0;
    public static int maxmainhandprogress = 10;
    public static int entityId = -1;
    public static boolean hasTarget = false;
    public static boolean block = false;
    public static int lastinvwidth = 0;
    public static int lastinvheight = 0;
    public static int lasteffectswidth = 0;
    public static int lasteffectsheight = 0;
    public static int lastmainhandwidth = 0;
    public static int lastmainhandheight = 0;

    public static void insightCounters() {
        boolean hasInsight = EffectUtil.hasBuff((LivingEntity)Minecraft.getInstance().player, ModEffects.INSIGHT);
        if (hasInsight && hasTarget && inventory.size() > 0) {
            if (invprogress < maxinvprogress) {
                ++invprogress;
            }
        } else if (invprogress > 0) {
            --invprogress;
        }
        if (hasInsight && hasTarget && effects.size() > 0 && !block) {
            if (effectsprogress < maxeffectsprogress) {
                ++effectsprogress;
            }
        } else if (effectsprogress > 0) {
            --effectsprogress;
        }
        if (hasInsight && hasTarget && inventory.size() > 0 && !block && mainhandindex >= 0) {
            if (mainhandprogress < maxmainhandprogress) {
                ++mainhandprogress;
            }
        } else if (mainhandprogress > 0) {
            --mainhandprogress;
        }
    }

    public static void insightOverlay(GuiGraphics graphics) {
        boolean hasInsight = EffectUtil.hasBuff((LivingEntity)Minecraft.getInstance().player, ModEffects.INSIGHT);
        graphics.pose().pushPose();
        try {
            RenderInsightOverlay.renderInventoryTab(graphics, hasInsight);
            RenderInsightOverlay.renderEffectsTab(graphics, hasInsight);
            RenderInsightOverlay.renderMainHandTab(graphics, hasInsight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.disableBlend();
        graphics.pose().popPose();
    }

    public static void renderMainHandTab(GuiGraphics graphics, boolean hasInsight) {
        PoseStack matrix = graphics.pose();
        int y = RenderInsightOverlay.getScaledHeight() / 2 + 32 + MTConfig.INSIGHT_BOTTOM_Y;
        int x = RenderInsightOverlay.getScaledWidth() / 2 + MTConfig.INSIGHT_BOTTOM_X;
        int w = x / 2;
        int hinv = 0;
        boolean xoff = false;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int yoff = 9;
        int rowlen = 9;
        int xbuffer = 4;
        int ybuffer = 2;
        boolean numrows = true;
        ArrayList<String> enchanted = new ArrayList<String>();
        String name = null;
        if (mainhandprogress > 0 && !block) {
            RenderUtils.bindTexture(insight);
            if (inventory.size() > 0 && inventory.size() > mainhandindex && mainhandindex >= 0) {
                ItemStack stack = inventory.get(mainhandindex);
                name = stack.getHoverName().getString();
                ItemEnchantments enchants = stack.getItem().getAllEnchantments(stack, (HolderLookup.RegistryLookup)Minecraft.getInstance().level.registryAccess().lookup(Registries.ENCHANTMENT).get());
                Set m = enchants.keySet();
                int maxw = -1;
                int h = 0;
                for (Holder e : m) {
                    Enchantment cfr_ignored_0 = (Enchantment)e.value();
                    String n = Enchantment.getFullname((Holder)e, (int)enchants.getLevel(e)).getString();
                    maxw = Math.max(Minecraft.getInstance().font.width(n), maxw);
                    enchanted.add(n);
                    ++h;
                }
                maxw = Math.max(Minecraft.getInstance().font.width(name), maxw);
                w = maxw + 8 * xbuffer;
                lastmainhandheight = hinv = (h + 1) * (yoff + ybuffer + 2) + ybuffer * 12;
                lastmainhandwidth = w;
                RenderInsightOverlay.drawTexturedModalRect(matrix, x - w / 2, y + mainhandprogress, 130, 326, 252, 186, w, hinv, 100, 100, 1.0f, 1.0f, 1.0f, (float)mainhandprogress / (1.3f * (float)maxmainhandprogress), 0.001953125f);
            } else {
                RenderInsightOverlay.drawTexturedModalRect(matrix, x - lastmainhandwidth / 2, y + mainhandprogress, 130, 326, 252, 186, lastmainhandwidth, lastmainhandheight, 100, 100, 1.0f, 1.0f, 1.0f, (float)mainhandprogress / (1.3f * (float)maxmainhandprogress), 0.001953125f);
            }
        }
        if (hasInsight && mainhandprogress == maxmainhandprogress && name != null) {
            int sz = Minecraft.getInstance().font.width(name);
            Minecraft.getInstance().font.drawInBatch(name, (float)(x - sz / 2), (float)(y + ybuffer + mainhandprogress), 0xFFFFFF, false, matrix.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            int m = 1;
            for (String s : enchanted) {
                sz = Minecraft.getInstance().font.width(s);
                Minecraft.getInstance().font.drawInBatch(s, (float)(x - sz / 2), (float)(y + ybuffer + (yoff + ybuffer) * m++ + mainhandprogress), 0xBBBBBB, true, matrix.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
    }

    public static void renderEffectsTab(GuiGraphics graphics, boolean hasInsight) {
        PoseStack matrix = graphics.pose();
        int y = RenderInsightOverlay.getScaledHeight() / 2 + MTConfig.INSIGHT_LEFT_Y;
        int x = RenderInsightOverlay.getScaledWidth() / 2 + MTConfig.INSIGHT_LEFT_X;
        int w = x / 2;
        int hinv = 0;
        int xoff = 16;
        int yoff = 16;
        int rowlen = 9;
        int xbuffer = 2;
        int ybuffer = 2;
        int numrows = (int)Math.ceil((float)effects.size() / (float)rowlen);
        if (effectsprogress > 0 && !block) {
            RenderUtils.bindTexture(insight);
            if (effects.size() > 0) {
                w = Math.min(effects.size(), rowlen) * (xoff + xbuffer) + xbuffer * 6;
                lasteffectsheight = hinv = numrows * (yoff + ybuffer) + ybuffer * 2;
                lasteffectswidth = w;
                RenderInsightOverlay.drawTexturedModalRect(matrix, x - w - effectsprogress, y - hinv / 2, 0, 166, 256, 180, w, hinv, 100, 100, 1.0f, 1.0f, 1.0f, (float)effectsprogress / (1.3f * (float)maxeffectsprogress), 0.001953125f);
            } else {
                RenderInsightOverlay.drawTexturedModalRect(matrix, x - lasteffectswidth - effectsprogress, y - lasteffectsheight / 2, 0, 166, 256, 180, lasteffectswidth, lasteffectsheight, 100, 100, 1.0f, 1.0f, 1.0f, (float)effectsprogress / (1.3f * (float)maxeffectsprogress), 0.001953125f);
            }
        }
        MobEffectTextureManager potionspriteuploader = Minecraft.getInstance().getMobEffectTextures();
        if (hasInsight && effectsprogress == maxeffectsprogress) {
            for (int i = 0; i < effects.size(); ++i) {
                if (!effects.get(i).showIcon()) continue;
                TextureAtlasSprite texsprite = potionspriteuploader.get(effects.get(i).getEffect());
                ResourceLocation sprite = texsprite.atlasLocation();
                RenderUtils.bindTexture(sprite);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.blit(x - 16 - effectsprogress - xoff * (i % rowlen) - xbuffer, y - hinv / 2 + i / rowlen * yoff + ybuffer, -999, 18, 18, texsprite);
            }
        }
    }

    public static void renderInventoryTab(GuiGraphics graphics, boolean hasInsight) {
        PoseStack matrix = graphics.pose();
        int y = RenderInsightOverlay.getScaledHeight() / 2 + MTConfig.INSIGHT_RIGHT_Y;
        int x = RenderInsightOverlay.getScaledWidth() / 2 + MTConfig.INSIGHT_RIGHT_X;
        int w = x / 2;
        int hinv = 0;
        int xoff = 16;
        int yoff = 16;
        int rowlen = 9;
        int xbuffer = 2;
        int ybuffer = 2;
        int numrows = (int)Math.ceil((float)inventory.size() / (float)rowlen);
        if (invprogress > 0) {
            RenderUtils.bindTexture(insight);
            if (inventory.size() > 0) {
                w = Math.min(inventory.size(), rowlen) * (xoff + xbuffer) + xbuffer * 8;
                lastinvheight = hinv = numrows * (yoff + ybuffer) + ybuffer * 2;
                lastinvwidth = w;
                RenderInsightOverlay.drawTexturedModalRect(matrix, x + invprogress, y - hinv / 2, 256, 166, 256, 180, w, hinv, 100, 100, 1.0f, 1.0f, 1.0f, (float)invprogress / (1.3f * (float)maxinvprogress), 0.001953125f);
            } else {
                RenderInsightOverlay.drawTexturedModalRect(matrix, x + invprogress, y - lastinvheight / 2, 256, 166, 256, 180, lastinvwidth, lastinvheight, 100, 100, 1.0f, 1.0f, 1.0f, (float)invprogress / (1.3f * (float)maxinvprogress), 0.001953125f);
            }
        }
        if (hasInsight && invprogress == maxinvprogress) {
            for (int i = 0; i < inventory.size(); ++i) {
                matrix.pushPose();
                graphics.renderItem(inventory.get(i), x + invprogress + xoff * (i % rowlen) + xbuffer, y - hinv / 2 + i / rowlen * yoff + ybuffer);
                RenderSystem.disableBlend();
                matrix.popPose();
                matrix.pushPose();
                if (inventory.get(i).getCount() > 1) {
                    graphics.renderItemDecorations(Minecraft.getInstance().font, inventory.get(i), x + invprogress + xoff * (i % rowlen) + xbuffer, y - hinv / 2 + i / rowlen * yoff + ybuffer, "" + inventory.get(i).getCount());
                }
                matrix.popPose();
            }
        }
    }

    public static void drawTexturedModalRect(PoseStack matrix, int x, int y, int textureX, int textureY, int tx2, int ty2, int width, int height, int lx, int ly, float r, float g, float b, float a, float f) {
        matrix.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShader(() -> ModShaders.PASSTHROUGH_QUADS);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        float zLevel = -999.0f;
        bufferbuilder.addVertex((float)(x + 0), (float)(y + height), zLevel).setColor(r, g, b, a).setUv((float)textureX * f, (float)(textureY + ty2) * f).setUv2(lx, ly);
        bufferbuilder.addVertex((float)(x + width), (float)(y + height), zLevel).setColor(r, g, b, a).setUv((float)(textureX + tx2) * f, (float)(textureY + ty2) * f).setUv2(lx, ly);
        bufferbuilder.addVertex((float)(x + width), (float)(y + 0), zLevel).setColor(r, g, b, a).setUv((float)(textureX + tx2) * f, (float)(textureY + 0) * f).setUv2(lx, ly);
        bufferbuilder.addVertex((float)(x + 0), (float)(y + 0), zLevel).setColor(r, g, b, a).setUv((float)(textureX + 0) * f, (float)(textureY + 0) * f).setUv2(lx, ly);
        RenderSystem.enableCull();
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        matrix.popPose();
    }

    public static int getScaledHeight() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight();
    }

    public static int getScaledWidth() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth();
    }
}

