/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class ParticleSphere
extends Particle {
    public String loc;
    public float[] rgba = new float[4];
    public float softness = 0.01f;
    public float rotation = 0.0f;
    public float sz = 0.2f;
    public double slow = 0.6;
    public double grow = 0.4;
    public boolean shaders = false;
    public int image;

    public ParticleSphere(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double vx, double vy, double vz, String loc, float sz, float r, float g, float b, float a, boolean shaders, double grow) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, vx, vy, vz);
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.bCol = 1.0f;
        this.alpha = 0.4f;
        float maxAge = 50.0f + sz * 100.0f;
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime * scale);
        this.rgba[0] = r;
        this.rgba[1] = g;
        this.rgba[2] = b;
        this.rgba[3] = a;
        this.loc = loc;
        this.sz = sz;
        this.image = this.random.nextInt(6) + 1;
        this.shaders = shaders;
        this.slow = 0.6;
        this.grow = grow;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.rgba[3] <= 0.0f) {
            this.remove();
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.xd *= this.slow;
        this.yd *= this.slow;
        this.zd *= this.slow;
        this.rgba[3] = Math.max(0.0f, this.rgba[3] - 0.05f);
        this.sz = (float)((double)this.sz + this.grow);
        this.oRoll = this.roll;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderParticleSphere(ParticleSphere particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        double d0 = particle.xo + (particle.x - particle.xo) * (double)partialTicks;
        double d1 = particle.yo + (particle.y - particle.yo) * (double)partialTicks;
        double d2 = particle.zo + (particle.z - particle.zo) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        Entity e = Minecraft.getInstance().getCameraEntity();
        if (e != null) {
            float r = particle.rgba[0];
            float g = particle.rgba[1];
            float b = particle.rgba[2];
            float a = particle.rgba[3];
            MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
            ResourceLocation loc = ResourceLocation.parse((String)particle.loc);
            RenderType sphere = MahoujinRenderType.wrapGlowLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(loc, 0)), particle.rgba, particle.softness, particle.shaders);
            double size = Math.max(0.0, (double)particle.sz - particle.grow + particle.grow * (double)partialTicks);
            RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, (float)size, 20, 240, 240, r, g, b, a, sphere);
            buf.endBatch(sphere);
        }
        matrix.popPose();
    }
}

