/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.shader;

import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class ClipShaderInstance
extends ShaderInstance {
    Uniform CLIP_PLANE = new Uniform("uClipPlane", 7, 4, (Shader)this);
    Uniform MODEL_MATRIX = this.getUniform("ModelMat");

    public ClipShaderInstance(ResourceProvider provider, ResourceLocation shaderLocation, VertexFormat vertexFormat) throws IOException {
        super(provider, shaderLocation, vertexFormat);
        this.initializeUniform(this.CLIP_PLANE);
        this.initializeUniform(this.MODEL_MATRIX);
        this.clip_plane(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void initializeUniform(Uniform uniform) {
        String s1 = uniform.getName();
        int k = Uniform.glGetUniformLocation((int)this.getId(), (CharSequence)s1);
        uniform.setLocation(k);
    }

    public void clip_plane(float a, float b, float c, float d) {
        this.CLIP_PLANE.set(a, b, c, d);
    }

    public void model_matrix(Matrix4f m) {
        this.MODEL_MATRIX.set(m);
    }

    public void apply_clip() {
        this.CLIP_PLANE.upload();
        this.printGLERROR("CLIP_PLANE");
        this.MODEL_MATRIX.upload();
        this.printGLERROR("MODEL_MATRIX");
    }

    public void printGLERROR(String s) {
        int errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println(s + ": Could not create shaders " + errorCheckValue);
        }
    }

    public void apply() {
        super.apply();
        this.apply_clip();
    }

    public void close() {
        this.CLIP_PLANE.close();
        super.close();
    }
}

