/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.AlarmBoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.DrainLifeBoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.RaiseEnclosureBarrierMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.AscensionMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.EquivalentDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.OrderedDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.CatalystExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ChronalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.DurabilityExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.mystic.CupOfHeavenMahoujinTileEntity;
import stepsword.mahoutsukai.tile.projection.PowerConsolidationMahoujinTileEntity;
import stepsword.mahoutsukai.tile.secret.ProbabilityAlterMahoujinTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class MahoujinRenderer
implements BlockEntityRenderer<MahoujinTileEntity> {
    public static ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_changeable.png");
    public static ResourceLocation location_fay = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_changeable_fae.png");
    public static ResourceLocation spellClothLocation = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/spell_cloth.png");
    private static final ResourceLocation white = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");
    HashMap<ArrayList<String>, MahoujinData> loadedMahoujin = new HashMap();
    public static int SIDE_SIZE = 256;
    public static int S_WIDTH = 256;
    public static int S_HEIGHT = 256;
    public static int PIXEL_COUNT = SIDE_SIZE * SIDE_SIZE;
    BlockEntityRenderDispatcher renderer;
    private static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");
    private static final ResourceLocation circle = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/blood-circle.png");
    private static final ResourceLocation circle2 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/blood-circle2.png");
    private static final ResourceLocation circle3 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/blood-circle3.png");
    private static final ResourceLocation square2 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/blood-square2.png");
    private static final ResourceLocation fcircle = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/fay-circle.png");
    private static final ResourceLocation fcircle2 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/fay-circle2.png");
    private static final ResourceLocation fcircle3 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/fay-circle3.png");
    private static final ResourceLocation fsquare2 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/fay-square2.png");

    public MahoujinRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        this.renderer = rendererDispatcherIn.getBlockEntityRenderDispatcher();
    }

    public void render(MahoujinTileEntity mahoujin, float partialTicks, PoseStack matrix, MultiBufferSource MultiBufferSource2, int v1, int v2) {
        boolean on;
        UnorderedList catalysts = mahoujin.getCatalysts();
        if (catalysts == null) {
            catalysts = new UnorderedList();
        }
        ArrayList<String> orderM = catalysts.getOrder();
        ArrayList<String> order = new ArrayList<String>();
        if (orderM != null) {
            for (String s : orderM) {
                order.add(s);
            }
        }
        if (mahoujin.isFay()) {
            order.add("fay");
        }
        boolean bl = on = mahoujin.getLevel() != null && MahoujinRenderer.mahoujinOn(mahoujin);
        if (MTConfig.OLD_CIRCLE_RENDER) {
            this.oldRender(mahoujin, order, matrix, MultiBufferSource2, on, v1, v2);
        } else {
            MahoujinRenderer.circleRender(mahoujin.getLevel() == null ? 0L : Minecraft.getInstance().level.getGameTime(), on, mahoujin.hasCloth(), mahoujin.isFay(), matrix, MultiBufferSource2, order, v1, v2);
        }
        if (mahoujin instanceof AlarmBoundaryMahoujinTileEntity) {
            AlarmBoundaryMahoujinTileEntity alarm = (AlarmBoundaryMahoujinTileEntity)mahoujin;
            if (mahoujin.getCasterUUID() != null && mahoujin.getCasterUUID().equals(Minecraft.getInstance().player.getUUID())) {
                this.renderStringAboveCircle(matrix, MultiBufferSource2, alarm.getAlarmName());
            }
        }
        if (mahoujin instanceof DrainLifeBoundaryMahoujinTileEntity) {
            DrainLifeBoundaryMahoujinTileEntity drain = (DrainLifeBoundaryMahoujinTileEntity)mahoujin;
            if (mahoujin.getCasterUUID() != null && mahoujin.getCasterUUID().equals(Minecraft.getInstance().player.getUUID())) {
                this.renderStringAboveCircle(matrix, MultiBufferSource2, drain.getWhitelistName());
            }
        }
        if (mahoujin instanceof CupOfHeavenMahoujinTileEntity && MTConfig.HEAVENS_CUP_CLIENT_CIRCLE) {
            CupOfHeavenMahoujinTileEntity cup = (CupOfHeavenMahoujinTileEntity)mahoujin;
            MahoujinRenderer.cupRender(cup, partialTicks, matrix, MultiBufferSource2, v1, v2);
        }
        if (mahoujin instanceof ScryingMahoujinTileEntity) {
            ScryingMahoujinTileEntity scry = (ScryingMahoujinTileEntity)mahoujin;
            MahoujinRenderer.scryingRender(scry, partialTicks, matrix, MultiBufferSource2, v1, v2);
        }
    }

    public static void circleRender(long time, boolean on, boolean cloth, boolean fay, PoseStack matrix, MultiBufferSource buffer, ArrayList<String> order, int v1, int v2) {
        RenderType s2;
        RenderType c3;
        RenderType c2;
        RenderType c;
        float rr = 1.0f;
        float gg = 1.0f;
        float bb = 1.0f;
        float aa = 1.0f;
        Color[] colors = MahoujinRenderer.getColors(order);
        float r1 = (float)colors[0].getRed() / 255.0f;
        float g1 = (float)colors[0].getGreen() / 255.0f;
        float b1 = (float)colors[0].getBlue() / 255.0f;
        float a1 = (float)colors[0].getAlpha() / 255.0f;
        float r2 = (float)colors[1].getRed() / 255.0f;
        float g2 = (float)colors[1].getGreen() / 255.0f;
        float b2 = (float)colors[1].getBlue() / 255.0f;
        float a2 = (float)colors[1].getAlpha() / 255.0f;
        float r3 = (float)colors[2].getRed() / 255.0f;
        float g3 = (float)colors[2].getGreen() / 255.0f;
        float b3 = (float)colors[2].getBlue() / 255.0f;
        float a3 = (float)colors[2].getAlpha() / 255.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        float oscparam = 0.1f;
        long t = time;
        long t2 = t * 5L;
        float oscillate = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 100.0f));
        float oscillate1 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 90.0f));
        float oscillate2 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 80.0f));
        float oscillate3 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 70.0f));
        float oscillate4 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 60.0f));
        float oscillate5 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 50.0f));
        if (!on) {
            t2 = 0L;
            t = 0L;
            oscillate = 0.0f;
            oscillate1 = 0.0f;
            oscillate2 = 0.0f;
            oscillate3 = 0.0f;
            oscillate4 = 0.0f;
            oscillate5 = 0.0f;
        }
        if (MTConfig.OLD_CIRCLE_ANIM) {
            oscillate = 0.0f;
            oscillate1 = 0.0f;
            oscillate2 = 0.0f;
            oscillate3 = 0.0f;
            oscillate4 = 0.0f;
            oscillate5 = 0.0f;
        }
        matrix.pushPose();
        matrix.translate(0.5f, 0.0f, 0.5f);
        matrix.pushPose();
        MahoujinRenderer.renderCloth(matrix, buffer, cloth, v1, v2);
        matrix.popPose();
        if (fay) {
            c = MahoujinRenderType.createMahoujinRenderType(fcircle, 1, false);
            c2 = MahoujinRenderType.createMahoujinRenderType(fcircle2, 1, false);
            c3 = MahoujinRenderType.createMahoujinRenderType(fcircle3, 1, false);
            s2 = MahoujinRenderType.createMahoujinRenderType(fsquare2, 1, false);
        } else {
            c = MahoujinRenderType.createMahoujinRenderType(circle, 1, false);
            c2 = MahoujinRenderType.createMahoujinRenderType(circle2, 1, false);
            c3 = MahoujinRenderType.createMahoujinRenderType(circle3, 1, false);
            s2 = MahoujinRenderType.createMahoujinRenderType(square2, 1, false);
        }
        RenderType lines = MahoujinRenderType.createMahoujinRenderType(white, 1, false);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate, 0.0f, 1.0f, 0.0f, false);
        MahoujinRenderer.renderTex(c, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate1, 0.0f, 0.69f, 0.0f, false);
        MahoujinRenderer.renderTex(c2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate2, 0.0f, 0.43f, 0.0f, false);
        MahoujinRenderer.renderTex(c3, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate1, 0.0f, 0.19f, (float)(-t) * 1.0f, false);
        MahoujinRenderer.drawTriangle(lines, buffer, matrix, r1, g1, b1, a1);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 2.0E-4f + oscillate1, 0.0f, 0.19f, 40.0f - (float)t * 2.0f, false);
        MahoujinRenderer.drawTriangle(lines, buffer, matrix, r2, g2, b2, a2);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 3.0E-4f + oscillate1, 0.0f, 0.19f, 80.0f - (float)t * 3.0f, false);
        MahoujinRenderer.drawTriangle(lines, buffer, matrix, r3, g3, b3, a3);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate, 0.0f, 1.2f, 0L + t, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate1, 0.0f, 1.2f, 0.0f + (float)t * 2.0f, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate2, 0.0f, 1.2f, 30L + t, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate3, 0.0f, 1.2f, 30L + t * 2L, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate4, 0.0f, 1.2f, 60L + t, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate5, 0.0f, 1.2f, 60L + t * 2L, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        matrix.popPose();
    }

    public static void drawTriangle(RenderType type, MultiBufferSource buffer, PoseStack matrix, float rr, float gg, float bb, float aa) {
        float wide = 0.86602527f;
        float high = 0.5000002f;
        float r = -1.0f;
        float width = 0.8f;
        float wide2 = width * wide;
        float high2 = width * high;
        float r2 = r * width;
        int lightmapX = 240;
        int lightmapY = 240;
        Matrix4f positionMatrix = matrix.last().pose();
        VertexConsumer b = buffer.getBuffer(type);
        b.addVertex(positionMatrix, 0.0f, 0.06875f, r).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, wide, 0.06875f, high).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, wide2, 0.06875f, high2).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, 0.0f, 0.06875f, r2).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, 0.0f, 0.06875f, r).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, -wide, 0.06875f, high).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, -wide2, 0.06875f, high2).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, 0.0f, 0.06875f, r2).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, -wide, 0.06875f, high).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, wide, 0.06875f, high).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, wide2, 0.06875f, high2).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, -wide2, 0.06875f, high2).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
    }

    public static void renderTex(RenderType type, MultiBufferSource buffer, PoseStack matrix, float rr, float gg, float bb, float aa, int lightmapX, int lightmapY) {
        Matrix4f positionMatrix = matrix.last().pose();
        VertexConsumer b = buffer.getBuffer(type);
        b.addVertex(positionMatrix, -0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, 0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, 0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        b.addVertex(positionMatrix, -0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
    }

    public static void moveTex(PoseStack m, float x, float y, float z, float s, float degrees, boolean reverse) {
        if (reverse) {
            m.popPose();
        } else {
            m.pushPose();
            m.translate(x, y, z);
            RenderUtils.rotateQ(degrees, 0.0f, 1.0f, 0.0f, m);
            m.scale(s, 1.0f, s);
        }
    }

    public static void scryingRender(ScryingMahoujinTileEntity scrying, float partialTicks, PoseStack stack, MultiBufferSource buffer, int v1, int v2) {
        LivingEntity e = scrying.getScryTarget();
        stack.pushPose();
        if (e != null) {
            float offset;
            BlockPos pos = scrying.getBlockPos();
            float xx = offset = 0.5f;
            float yy = offset;
            float zz = offset;
            float scale = 0.2f;
            double scaleall = 0.2;
            double invscaleall = 1.0 / scaleall;
            stack.translate(xx, yy, zz);
            stack.scale(scale, scale, scale);
            float f = Mth.lerp((float)partialTicks, (float)e.yRotO, (float)e.yRot);
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)e, 0.0, 0.0, 0.0, partialTicks, f, stack, buffer, v1);
            stack.translate(invscaleall * -0.125, 0.0, invscaleall * -0.125);
            if (scrying.targetPos != null) {
                stack.translate(-0.5 * (scrying.targetPos.x - Math.floor(scrying.targetPos.x)), -0.5 * (scrying.targetPos.y - Math.floor(scrying.targetPos.y)), -0.5 * (scrying.targetPos.z - Math.floor(scrying.targetPos.z)));
            }
            if (scrying.lst != null && scrying.lst.size() > 0) {
                int index = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 2 && index < scrying.lst.size(); ++index, ++k) {
                            ScryingMahoujinTileEntity.BlockPosInfo info = scrying.lst.get(index);
                            if (info.state == null || info.state.getBlock() == Blocks.AIR || info.state.getBlock() == Blocks.CAVE_AIR || info.state.getBlock() == Blocks.VOID_AIR || info.te != null) continue;
                            stack.translate((float)i, (float)k, (float)j);
                            try {
                                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(info.state, stack, buffer, v1, v2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            stack.translate((float)(-i), (float)(-k), (float)(-j));
                        }
                    }
                }
            }
        }
        stack.popPose();
    }

    public static void renderCloth(PoseStack stack, MultiBufferSource buffer, boolean renderCloth, int v1, int v2) {
        RenderType type = MahoujinRenderType.createShadedRenderType(spellClothLocation, 0, false);
        float rr = 1.0f;
        float gg = 1.0f;
        float bb = 1.0f;
        float aa = 1.0f;
        VertexConsumer b = buffer.getBuffer(type);
        Matrix4f positionMatrix = stack.last().pose();
        int clothlightX = v1 & 0xFFFF;
        int clothlightY = v1 >> 16 & 0xFFFF;
        if (renderCloth) {
            b.addVertex(positionMatrix, -0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, -0.5f).setColor(rr -= 0.4f, gg -= 0.4f, bb -= 0.4f, aa).setUv(0.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, 0.5f, 0.0f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(clothlightX, clothlightY);
            b.addVertex(positionMatrix, -0.5f, 0.0f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(clothlightX, clothlightY);
        }
    }

    public static void cupRender(CupOfHeavenMahoujinTileEntity cup, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int v1, int v2) {
        float size;
        matrix.pushPose();
        float yv = cup.getBlockPos().getY();
        if (yv <= 0.0f) {
            yv = 1.0f;
        }
        float offsetx = 0.0f;
        float offsety = 120.0f - yv;
        float offsetz = 0.0f;
        float time = cup.getLevel().getDayTime() % 24000L;
        if (time > 18000.0f) {
            time -= 24000.0f;
        }
        float timeColor = Math.abs(time - 6000.0f) / 12000.0f;
        float r1 = 0.19215687f;
        float g1 = 0.007843138f;
        float b1 = 0.8901961f;
        float a1 = 1.0f;
        float r2 = 0.47058824f;
        float g2 = 0.83137256f;
        float b2 = 1.0f;
        float a2 = 1.0f;
        float r = r1 + (r2 - r1) * timeColor;
        float g = g1 + (g2 - g1) * timeColor;
        float b = b1 + (b2 - b1) * timeColor;
        float a = a1 + (a2 - a1) * timeColor;
        float rotation = ClientHandler.clientTickCounter;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float ring = 0.0f;
        int twopower = 0;
        rotation = rotation - 1.0f + partialTicks;
        if (yv > 80.0f) {
            size = 2.0f;
        } else {
            while (yv > 2.0f) {
                yv /= 2.0f;
                ++twopower;
            }
            size = 20.0f / (float)twopower;
        }
        if (size < 0.4f) {
            size = 0.4f;
        }
        matrix.translate((double)offsetx + 0.5, (double)offsety, (double)offsetz + 0.5);
        matrix.scale(size, size, size);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
        int lightmapX = 240;
        int lightmapY = 240;
        RenderType type = MahoujinRenderType.createMahoujinNoFogRenderType(mahoujin, 0, true);
        VertexConsumer bb = buffer.getBuffer(type);
        Matrix4f m = matrix.last().pose();
        bb.addVertex(m, -0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, -0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        RenderUtils.renderRing(matrix, buffer, 0.0, ring, size / 2.0f + 0.125f, 0.125f, 128, lightmapX, lightmapY, r, g, b, a, 0);
        matrix.popPose();
    }

    public void renderStringAboveCircle(PoseStack matrixStackIn, MultiBufferSource bufferIn, String displayNameIn) {
        if (displayNameIn != null) {
            MutableComponent text = Component.literal((String)displayNameIn);
            float f = 0.5f;
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, (double)f, 0.5);
            matrixStackIn.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            RenderUtils.rotateQ(180.0f, 0.0f, 1.0f, 0.0f, matrixStackIn);
            matrixStackIn.scale(-0.025f, -0.025f, 0.025f);
            Font fontrenderer = Minecraft.getInstance().gui.getFont();
            int color = 0xDDDDFF;
            float f2 = -fontrenderer.width((FormattedText)text) / 2;
            RenderSystem.disableCull();
            fontrenderer.drawInBatch(text.getVisualOrderText(), f2, 0.0f, color, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            RenderSystem.enableCull();
            matrixStackIn.popPose();
        }
    }

    public boolean shouldRenderOffScreen(MahoujinTileEntity te) {
        return true;
    }

    public int getColor(int alpha, int colorValue) {
        int i = alpha;
        int j = colorValue >> 16 & 0xFF;
        int k = colorValue >> 8 & 0xFF;
        int l = colorValue & 0xFF;
        return i << 24 | l << 16 | k << 8 | j;
    }

    public static Color[] getColors(ArrayList<String> order) {
        Color newFirst = new Color(0, 0, 0, 0);
        Color newSecond = new Color(0, 0, 0, 0);
        Color newThird = new Color(0, 0, 0, 0);
        if (order.size() > 0) {
            if (!order.get(0).equals("fay")) {
                newFirst = ModItems.catalystMap.get((Object)order.get((int)0)).COLOR;
            }
            if (order.size() > 1) {
                if (!order.get(1).equals("fay")) {
                    newSecond = ModItems.catalystMap.get((Object)order.get((int)1)).COLOR;
                }
                if (order.size() > 2 && !order.get(2).equals("fay")) {
                    newThird = ModItems.catalystMap.get((Object)order.get((int)2)).COLOR;
                }
            }
        }
        Color[] colors = new Color[]{newFirst, newSecond, newThird};
        return colors;
    }

    public static boolean mahoujinOn(MahoujinTileEntity te) {
        boolean on = false;
        if (!te.hasCloth()) {
            if (te instanceof BoundaryMahoujinTileEntity) {
                BoundaryMahoujinTileEntity mte = (BoundaryMahoujinTileEntity)te;
                if (mte.shouldIPerformBarrier()) {
                    on = true;
                }
            } else if (te instanceof AscensionMahoujinTileEntity || te instanceof OrderedDisplacementMahoujinTileEntity || te instanceof EquivalentDisplacementMahoujinTileEntity || te instanceof AlchemicalExchangeMahoujinTileEntity || te instanceof PowerConsolidationMahoujinTileEntity || te instanceof RaiseEnclosureBarrierMahoujinTileEntity || te instanceof ScryingMahoujinTileEntity || te instanceof ChronalExchangeMahoujinTileEntity || te instanceof DurabilityExchangeMahoujinTileEntity || te instanceof CatalystExchangeMahoujinTileEntity || te instanceof ProbabilityAlterMahoujinTileEntity) {
                on = true;
            }
        }
        return on;
    }

    public void oldRender(MahoujinTileEntity mahoujin, ArrayList<String> order, PoseStack matrix, MultiBufferSource buffer, boolean on, int v1, int v2) {
        MahoujinData displayMe;
        if (this.loadedMahoujin.containsKey(order)) {
            displayMe = this.loadedMahoujin.get(order);
        } else {
            if (mahoujin.isFay()) {
                RenderUtils.bindTexture(location_fay);
            } else {
                RenderUtils.bindTexture(location);
            }
            PIXEL_COUNT = S_WIDTH * S_HEIGHT;
            displayMe = new MahoujinData(order);
            this.loadedMahoujin.put(order, displayMe);
            displayMe.changeMahoujin(order);
            MahoujinData image = new MahoujinData(order);
            try {
                InputStream io = mahoujin.isFay() ? ((Resource)Minecraft.getInstance().getResourceManager().getResource(location_fay).get()).open() : ((Resource)Minecraft.getInstance().getResourceManager().getResource(location).get()).open();
                image.colors = NativeImage.read((InputStream)io);
                image.changeMahoujin(order);
                displayMe = image;
                this.loadedMahoujin.put(order, displayMe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        displayMe.render(mahoujin, matrix, buffer, on, v1, v2);
    }

    public AABB getRenderBoundingBox(MahoujinTileEntity blockEntity) {
        if (blockEntity instanceof CupOfHeavenMahoujinTileEntity) {
            return AABB.INFINITE;
        }
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }

    class MahoujinData {
        NativeImage colors;
        public final Color first = new Color(0, 0, 255, 255);
        public final Color second = new Color(0, 255, 0, 255);
        public final Color third = new Color(255, 255, 0, 255);
        public String texName = "mahoujin";
        public DynamicTexture dynamicTexture;
        public ResourceLocation texLocation;

        public MahoujinData(ArrayList<String> order) {
            for (int i = 0; i < order.size(); ++i) {
                this.texName = this.texName + "_" + order.get(i);
            }
            this.dynamicTexture = new DynamicTexture(S_WIDTH, S_HEIGHT, true);
            this.texLocation = Minecraft.getInstance().getTextureManager().register("mahoutsukai/" + this.texName, this.dynamicTexture);
            this.colors = this.dynamicTexture.getPixels();
        }

        public void changeMahoujin(ArrayList<String> order) {
            Color newFirst = new Color(0, 0, 0, 0);
            Color newSecond = new Color(0, 0, 0, 0);
            Color newThird = new Color(0, 0, 0, 0);
            if (order.size() > 0) {
                if (!order.get(0).equals("fay")) {
                    newFirst = ModItems.catalystMap.get((Object)order.get((int)0)).COLOR;
                }
                if (order.size() > 1) {
                    if (!order.get(1).equals("fay")) {
                        newSecond = ModItems.catalystMap.get((Object)order.get((int)1)).COLOR;
                    }
                    if (order.size() > 2 && !order.get(2).equals("fay")) {
                        newThird = ModItems.catalystMap.get((Object)order.get((int)2)).COLOR;
                    }
                }
            }
            int firstRGB = MahoujinRenderer.this.getColor(this.first.getAlpha(), this.first.getRGB());
            int secondRGB = MahoujinRenderer.this.getColor(this.second.getAlpha(), this.second.getRGB());
            int thirdRGB = MahoujinRenderer.this.getColor(this.third.getAlpha(), this.third.getRGB());
            for (int i = 0; i < S_WIDTH; ++i) {
                for (int j = 0; j < S_HEIGHT; ++j) {
                    int pixel = this.colors.getPixelRGBA(i, j);
                    if (pixel == firstRGB) {
                        this.colors.setPixelRGBA(i, j, MahoujinRenderer.this.getColor(newFirst.getAlpha(), newFirst.getRGB()));
                        continue;
                    }
                    if (pixel == secondRGB) {
                        this.colors.setPixelRGBA(i, j, MahoujinRenderer.this.getColor(newSecond.getAlpha(), newSecond.getRGB()));
                        continue;
                    }
                    if (pixel != thirdRGB) continue;
                    this.colors.setPixelRGBA(i, j, MahoujinRenderer.this.getColor(newThird.getAlpha(), newThird.getRGB()));
                }
            }
            try {
                this.dynamicTexture = new DynamicTexture(this.colors);
            }
            catch (Exception e) {
                Utils.err(e.toString());
            }
            this.dynamicTexture.upload();
            this.texLocation = Minecraft.getInstance().getTextureManager().register("mahoutsukai/" + this.texName, this.dynamicTexture);
        }

        public void render(MahoujinTileEntity te, PoseStack matrix, MultiBufferSource buffer, boolean on, int v1, int v2) {
            boolean renderCloth = te.hasCloth();
            int lightmapX = 128;
            int lightmapY = 240;
            matrix.pushPose();
            matrix.translate(0.5f, 0.0f, 0.5f);
            float rr = 1.0f;
            float gg = 1.0f;
            float bb = 1.0f;
            float aa = 1.0f;
            Matrix4f positionMatrix = matrix.last().pose();
            if (renderCloth) {
                MahoujinRenderer.renderCloth(matrix, buffer, renderCloth, v1, v2);
            }
            if (on) {
                RenderUtils.rotateQ((float)((double)ClientHandler.clientTickCounter * MTConfig.BOUNDARY_SPEED % 360.0), 0.0f, 1.0f, 0.0f, matrix);
            }
            RenderType type = MahoujinRenderType.createMahoujinRenderType(this.texLocation, 1, false);
            VertexConsumer b = buffer.getBuffer(type);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, 0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
            b.addVertex(positionMatrix, 0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
            b.addVertex(positionMatrix, -0.5f, 0.0625f, -0.5f).setColor(rr, gg, bb, aa).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
            matrix.popPose();
        }
    }
}

