/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;

public class InvisibleBarrierBlockTileEntity
extends UpdatingTileEntity {
    private UUID casterUUID;
    public BlockPos boundaryCircle;
    public long timeN = 21L;
    public long timeE = 21L;
    public long timeW = 21L;
    public long timeS = 21L;
    public long timeU = 21L;
    public long timeD = 21L;
    public static final int fadeTicks = 20;
    public static int updateWhiteListTicks = 20;
    public static final String CASTER_ID = "caster_uuid";
    public static final String TIME_SINCE_COLLISION = "time_since_last_collision";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_X = "original_boundary_circle_x";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Y = "original_boundary_circle_y";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Z = "original_boundary_circle_z";
    public static final String WHITELIST_TAG = "whitelist";
    public HashSet<UUID> whitelist;

    public InvisibleBarrierBlockTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.invisibleBarrier.get(), p, bs);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.casterUUID != null) {
            compound.putUUID(CASTER_ID, this.casterUUID);
        }
        compound.putLong("time_since_last_collisionN", this.timeN);
        compound.putLong("time_since_last_collisionE", this.timeE);
        compound.putLong("time_since_last_collisionW", this.timeW);
        compound.putLong("time_since_last_collisionS", this.timeS);
        compound.putLong("time_since_last_collisionU", this.timeU);
        compound.putLong("time_since_last_collisionD", this.timeD);
        if (this.boundaryCircle != null) {
            compound.putInt(ORIGINAL_BOUNDARY_CIRCLE_X, this.boundaryCircle.getX());
            compound.putInt(ORIGINAL_BOUNDARY_CIRCLE_Y, this.boundaryCircle.getY());
            compound.putInt(ORIGINAL_BOUNDARY_CIRCLE_Z, this.boundaryCircle.getZ());
        }
        if (this.whitelist != null) {
            CompoundTag tmp = new CompoundTag();
            int z = 0;
            for (UUID uuid : this.whitelist) {
                tmp.putUUID("MAHOUTSUKAI_WHITELIST_" + z++, uuid);
            }
            compound.put(WHITELIST_TAG, (Tag)tmp);
        }
        super.saveAdditional(compound, provider);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.casterUUID = compound.hasUUID(CASTER_ID) ? compound.getUUID(CASTER_ID) : null;
        this.timeN = compound.getLong("time_since_last_collisionN");
        this.timeE = compound.getLong("time_since_last_collisionE");
        this.timeW = compound.getLong("time_since_last_collisionW");
        this.timeS = compound.getLong("time_since_last_collisionS");
        this.timeU = compound.getLong("time_since_last_collisionU");
        this.timeD = compound.getLong("time_since_last_collisionD");
        if (compound.contains(ORIGINAL_BOUNDARY_CIRCLE_X) && compound.contains(ORIGINAL_BOUNDARY_CIRCLE_Y) && compound.contains(ORIGINAL_BOUNDARY_CIRCLE_Z)) {
            this.boundaryCircle = new BlockPos(compound.getInt(ORIGINAL_BOUNDARY_CIRCLE_X), compound.getInt(ORIGINAL_BOUNDARY_CIRCLE_Y), compound.getInt(ORIGINAL_BOUNDARY_CIRCLE_Z));
        }
        if (compound.contains(WHITELIST_TAG)) {
            CompoundTag nbt;
            if (this.whitelist == null) {
                this.whitelist = new HashSet();
            }
            if ((nbt = (CompoundTag)compound.get(WHITELIST_TAG)) != null) {
                for (String s : nbt.getAllKeys()) {
                    this.whitelist.add(nbt.getUUID(s));
                }
            }
        }
        super.loadAdditional(compound, provider);
    }

    public long getTimeSinceCollision(Direction facing) {
        if (this.level != null) {
            if (facing == Direction.NORTH) {
                return this.level.getGameTime() - this.timeN;
            }
            if (facing == Direction.EAST) {
                return this.level.getGameTime() - this.timeE;
            }
            if (facing == Direction.WEST) {
                return this.level.getGameTime() - this.timeW;
            }
            if (facing == Direction.SOUTH) {
                return this.level.getGameTime() - this.timeS;
            }
            if (facing == Direction.DOWN) {
                return this.level.getGameTime() - this.timeD;
            }
            if (facing == Direction.UP) {
                return this.level.getGameTime() - this.timeU;
            }
        }
        return 21L;
    }

    public void setTimeOfCollision(long t, Direction facing) {
        if (facing == Direction.NORTH) {
            this.timeN = t;
        }
        if (facing == Direction.EAST) {
            this.timeE = t;
        }
        if (facing == Direction.WEST) {
            this.timeW = t;
        }
        if (facing == Direction.SOUTH) {
            this.timeS = t;
        }
        if (facing == Direction.DOWN) {
            this.timeD = t;
        }
        if (facing == Direction.UP) {
            this.timeU = t;
        }
        this.sendUpdates();
    }

    public Player getCaster() {
        try {
            Player caster = this.level.getPlayerByUUID(this.casterUUID);
            return caster;
        }
        catch (Exception e) {
            return null;
        }
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setBoundaryCircle(BlockPos p) {
        this.boundaryCircle = p;
        this.sendUpdates();
    }

    public void setCaster(Player caster) {
        this.casterUUID = caster.getUUID();
        this.sendUpdates();
    }
}

