/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.ScrollGiver;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RaiseEnclosureBarrierMahoujinTileEntity
extends MahoujinTickingTileEntity
implements ScrollGiver {
    public static final String RAISED = "MAHOUTSUKAI_NUM_TIMES_RAISED";
    private int numTimesRaised = 0;

    public RaiseEnclosureBarrierMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.raiseEnclosureBoundary.get(), p, bs);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt(RAISED, this.numTimesRaised);
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.numTimesRaised = compound.getInt(RAISED);
        super.loadAdditional(compound, provider);
    }

    @Override
    public int blockCycle() {
        return MTConfig.ENCLOSURE_BARRIER_CYCLE;
    }

    @Override
    public void mahoujinTick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        if (this.numTimesRaised >= MTConfig.ENCLOSURE_BARRIER_RADIUS - 1) {
            EffectUtil.tryChangeBlockState(true, this.worldPosition, Blocks.AIR.defaultBlockState(), level, this.getCaster());
        } else {
            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.worldPosition, level, this.getCasterUUID(), MTConfig.ENCLOSURE_BARRIER_MANA_COST);
            if (nearbyBatteriesGaveMana || this.getCaster() != null && PlayerManaManager.drainMana(this.getCaster(), MTConfig.ENCLOSURE_BARRIER_MANA_COST, false, true) == MTConfig.ENCLOSURE_BARRIER_MANA_COST) {
                this.raiseEnclosure();
                ++this.numTimesRaised;
            }
        }
    }

    public void raiseEnclosure() {
        int bottom = MTConfig.ENCLOSURE_BARRIER_RADIUS - this.numTimesRaised - 1;
        Stream box = BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-MTConfig.ENCLOSURE_BARRIER_RADIUS, -bottom, -MTConfig.ENCLOSURE_BARRIER_RADIUS), (BlockPos)this.worldPosition.offset(MTConfig.ENCLOSURE_BARRIER_RADIUS, -bottom, MTConfig.ENCLOSURE_BARRIER_RADIUS));
        box.forEach(tmp -> {
            int k;
            if (tmp.getY() == this.worldPosition.getY() - bottom && (tmp.getX() == this.worldPosition.getX() - MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.getX() == this.worldPosition.getX() + MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.getZ() == this.worldPosition.getZ() - MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.getZ() == this.worldPosition.getZ() + MTConfig.ENCLOSURE_BARRIER_RADIUS) && (k = this.checkValidColumn((BlockPos)tmp)) > 0) {
                for (int i = k; i > 0; --i) {
                    BlockPos p = tmp.offset(0, i, 0);
                    EffectUtil.tryChangeBlockState(false, p, this.level.getBlockState(p.offset(0, -1, 0)), this.level, this.getCaster());
                }
                EffectUtil.tryChangeBlockState(false, tmp, Blocks.AIR.defaultBlockState(), this.level, this.getCaster());
            }
        });
    }

    public int checkValidColumn(BlockPos p) {
        for (int k = this.level.getMinBuildHeight(); k < this.level.getMaxBuildHeight() - p.getY() - 1; ++k) {
            if (Utils.isBlockAir(this.level, p.offset(0, k, 0)) && k >= MTConfig.ENCLOSURE_BARRIER_RADIUS - 1) {
                return k;
            }
            if (this.level.getBlockEntity(p.offset(0, k, 0)) != null) {
                return -1;
            }
            if (!EffectUtil.unchangableBlock(this.level.getBlockState(p.offset(0, k, 0)).getBlock())) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryRaiseEnclosureScroll.get());
    }
}

