/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.circuits;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;

public class ManaCircuitTileEntity
extends UpdatingTileEntity {
    private boolean on = false;
    private int storedMana = 0;
    private UUID ownerUUID = null;
    private boolean fae = false;
    public static final String ON_TAG = "MAHOUTSUKAI_ON_TAG";
    public static final String MANA_TAG = "MAHOUTSUKAI_MANA_TAG";
    public static final String OWNER_TAG = "MAHOUTSUKAI_OWNER_TAG";
    public static final String FAE_TAG = "MAHOUTSUKAI_FAE_TAG";

    public ManaCircuitTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.circuit.get(), p, bs);
    }

    public ManaCircuitTileEntity(BlockEntityType<? extends ManaCircuitTileEntity> type, BlockPos p, BlockState bs) {
        super(type, p, bs);
    }

    public int getMaxMana() {
        return MTConfig.MANA_CIRCUIT_CAPACITY;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.storedMana = compound.getInt(MANA_TAG);
        this.on = compound.getBoolean(ON_TAG);
        if (compound.hasUUID(OWNER_TAG)) {
            this.ownerUUID = compound.getUUID(OWNER_TAG);
        }
        this.fae = compound.getBoolean(FAE_TAG);
        super.loadAdditional(compound, provider);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt(MANA_TAG, this.storedMana);
        compound.putBoolean(ON_TAG, this.on);
        if (this.ownerUUID != null) {
            compound.putUUID(OWNER_TAG, this.ownerUUID);
        }
        compound.putBoolean(FAE_TAG, this.fae);
        super.saveAdditional(compound, provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.storedMana = (Integer)input.getOrDefault(DataComponents.MANA_CIRCUIT_MANA_COMPONENT, (Object)0);
        this.ownerUUID = (UUID)input.getOrDefault(DataComponents.MANA_CIRCUIT_OWNER_COMPONENT, (Object)FaeEssence.faeID);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.MANA_CIRCUIT_MANA_COMPONENT, (Object)this.storedMana);
        builder.set(DataComponents.MANA_CIRCUIT_OWNER_COMPONENT, (Object)this.ownerUUID);
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean b) {
        this.on = b;
    }

    public int getMana() {
        return this.storedMana;
    }

    public void setMana(int m) {
        this.storedMana = m;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID m) {
        this.ownerUUID = m;
    }

    public void setFae(boolean b) {
        this.fae = b;
    }

    public boolean getFae() {
        return this.fae;
    }

    public boolean isRedstoneOn() {
        boolean z = this.isOn();
        if (this.level != null && this.worldPosition != null && this.level.hasNeighborSignal(this.worldPosition)) {
            return !z;
        }
        return z;
    }
}

