/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;
import stepsword.mahoutsukai.mana.ActiveCircleConfig;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.DataManagerPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ScryingEntityPacket;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.tile.AboveChecker;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class ScryingMahoujinTileEntity
extends MahoujinTickingTileEntity
implements AboveChecker {
    public LivingEntity scryTarget = null;
    public CompoundTag scryNBT = null;
    private float yaw = 0.0f;
    private float hyaw = 0.0f;
    private float ryaw = 0.0f;
    private float pitch = 0.0f;
    private float pyaw = 0.0f;
    private float phyaw = 0.0f;
    private float pryaw = 0.0f;
    private float ppitch = 0.0f;
    private double velx = 0.0;
    private double vely = 0.0;
    private double velz = 0.0;
    public Vec3 targetPos = null;
    public float prevSwingProgress = 0.0f;
    public float swingProgress = 0.0f;
    private UUID scryUniqueID = null;
    public float limbSwingAmount = 0.0f;
    public float prevLimbSwingAmount = 0.0f;
    public float limbSwing = 0.0f;
    public ArrayList<BlockPosInfo> lst = null;
    public List<SynchedEntityData.DataValue<?>> scryDataManager = null;
    private int scryTimer = 0;
    private String viewTarget = "";
    private String VIEW_TARGET = "MAHOUTSUKAI_VIEW_TARGET";
    private String SCRY_RENDER_YAW = "MAHOUTSUKAI_RENDER_YAW";
    private String SCRY_YAW = "MAHOUTSUKAI_YAW";
    private String SCRY_HEAD_YAW = "MAHOUTSUKAI_HYAW";
    private String SCRY_PITCH = "MAHOUTSUKAI_PITCH";
    private String SCRY_VEL_X = "MAHOUTSUKAI_VEL_X";
    private String SCRY_VEL_Y = "MAHOUTSUKAI_VEL_Y";
    private String SCRY_VEL_Z = "MAHOUTSUKAI_VEL_Z";
    private String SCRY_UNIQ = "MAHOUTSUKAI_SCRY_UNIQ";
    private String LIMB_SWING = "MAHOUTSUKAI_LS";
    private String LIMB_SWING_AMOUNT = "MAHOUTSUKAI_LSA";
    private String LIMB_SWING_PROGRESS = "MAHOUTSUKAI_LSP";
    private String SCRY_LOC_X = "MAHOUTSUKAI_LOC_X";
    private String SCRY_LOC_Y = "MAHOUTSUKAI_LOC_Y";
    private String SCRY_LOC_Z = "MAHOUTSUKAI_LOC_Z";
    private String SCRY_BLOCK = "MAHOUTSUKAI_BLOCK_";
    public boolean doRead = false;

    public ScryingMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.scrying.get(), p, bs);
    }

    public LivingEntity getScryTarget() {
        return this.scryTarget;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putString(this.VIEW_TARGET, this.viewTarget);
        if (this.scryTarget != null) {
            compound.putFloat(this.SCRY_PITCH, this.scryTarget.getXRot());
            compound.putFloat(this.SCRY_YAW, this.scryTarget.getYRot());
            compound.putFloat(this.SCRY_HEAD_YAW, this.scryTarget.yHeadRot);
            compound.putFloat(this.SCRY_RENDER_YAW, this.scryTarget.yBodyRot);
            compound.putFloat(this.SCRY_RENDER_YAW, this.scryTarget.yBodyRot);
            compound.putFloat(this.LIMB_SWING, this.scryTarget.walkAnimation.position());
            compound.putFloat(this.LIMB_SWING_AMOUNT, this.scryTarget.walkAnimation.speed());
            compound.putFloat(this.LIMB_SWING_PROGRESS, this.scryTarget.attackAnim);
            Vec3 epos = this.scryTarget.position();
            Vec3 emot = this.scryTarget.getDeltaMovement();
            compound.putDouble(this.SCRY_VEL_X, emot.x);
            compound.putDouble(this.SCRY_VEL_Y, emot.y);
            compound.putDouble(this.SCRY_VEL_Z, emot.z);
            compound.putDouble(this.SCRY_LOC_X, epos.x);
            compound.putDouble(this.SCRY_LOC_Y, epos.y);
            compound.putDouble(this.SCRY_LOC_Z, epos.z);
            compound.putUUID(this.SCRY_UNIQ, this.scryTarget.getUUID());
            int index = 0;
            int i = (int)Math.floor(epos.x - 1.0);
            while ((double)i <= epos.x + 1.0) {
                int j = (int)Math.floor(epos.z - 1.0);
                while ((double)j <= epos.z + 1.0) {
                    int k = (int)Math.floor(epos.y - 1.0);
                    while ((double)k <= epos.y + 2.0) {
                        BlockPos p = new BlockPos(i, k, j);
                        BlockPosInfo info = new BlockPosInfo(this, p, this.level);
                        CompoundTag infonbt = info.write();
                        compound.put(this.SCRY_BLOCK + index, (Tag)infonbt);
                        ++index;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            CompoundTag compoundTag = new CompoundTag();
        }
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.viewTarget = compound.getString(this.VIEW_TARGET);
        if (compound.contains(this.SCRY_YAW)) {
            this.yaw = compound.getFloat(this.SCRY_YAW);
        }
        if (compound.contains(this.SCRY_PITCH)) {
            this.pitch = compound.getFloat(this.SCRY_PITCH);
        }
        if (compound.contains(this.SCRY_HEAD_YAW)) {
            this.hyaw = compound.getFloat(this.SCRY_HEAD_YAW);
        }
        if (compound.contains(this.SCRY_RENDER_YAW)) {
            this.ryaw = compound.getFloat(this.SCRY_RENDER_YAW);
        }
        if (compound.contains(this.LIMB_SWING)) {
            this.limbSwing = compound.getFloat(this.LIMB_SWING);
        }
        if (compound.contains(this.LIMB_SWING_AMOUNT)) {
            this.limbSwingAmount = compound.getFloat(this.LIMB_SWING_AMOUNT);
        }
        if (compound.contains(this.LIMB_SWING_PROGRESS)) {
            this.swingProgress = compound.getFloat(this.LIMB_SWING_PROGRESS);
        }
        if (compound.contains(this.SCRY_VEL_X)) {
            this.velx = compound.getDouble(this.SCRY_VEL_X);
        }
        if (compound.contains(this.SCRY_VEL_Y)) {
            this.vely = compound.getDouble(this.SCRY_VEL_Y);
        }
        if (compound.contains(this.SCRY_VEL_Z)) {
            this.velz = compound.getDouble(this.SCRY_VEL_Z);
        }
        if (compound.hasUUID(this.SCRY_UNIQ)) {
            this.scryUniqueID = compound.getUUID(this.SCRY_UNIQ);
        }
        int index = 0;
        this.lst = new ArrayList();
        while (compound.contains(this.SCRY_BLOCK + index)) {
            BlockPosInfo info = new BlockPosInfo(this);
            info.read(compound.getCompound(this.SCRY_BLOCK + index), this.level);
            this.lst.add(info);
            ++index;
        }
        if (compound.contains(this.SCRY_LOC_X) && compound.contains(this.SCRY_LOC_Y) && compound.contains(this.SCRY_LOC_X)) {
            this.targetPos = new Vec3(compound.getDouble(this.SCRY_LOC_X), compound.getDouble(this.SCRY_LOC_Y), compound.getDouble(this.SCRY_LOC_Z));
        }
        this.doRead = true;
        super.loadAdditional(compound, provider);
    }

    @Override
    public void mahoujinTick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        if (!level.isClientSide) {
            if (this.scryTimer >= MTConfig.SCRYING_DURATION) {
                this.viewTarget = "";
                this.scryTarget = null;
                this.sendUpdates();
            }
            if (this.scryTarget != null && this.scryTarget.isAlive()) {
                boolean checkDirty = this.scryDataManager != null;
                List<SynchedEntityData.DataValue<?>> entries = this.getAll(this.scryTarget.getEntityData(), checkDirty);
                if (entries != null) {
                    ArrayList entriesCopy = new ArrayList(entries);
                    ArrayList toSend = new ArrayList(entriesCopy);
                    this.scryDataManager = entriesCopy;
                    if (!toSend.isEmpty()) {
                        int r = 32;
                        AABB aabb = new AABB((double)(this.worldPosition.getX() - r), (double)(this.worldPosition.getY() - r), (double)(this.worldPosition.getZ() - r), (double)(this.worldPosition.getX() + r), (double)(this.worldPosition.getY() + r), (double)(this.worldPosition.getZ() + r));
                        List players = level.getEntitiesOfClass(ServerPlayer.class, aabb);
                        for (ServerPlayer player : players) {
                            PacketHandler.sendTo(player, new DataManagerPacket(this.worldPosition, toSend));
                        }
                    }
                }
                this.scryNBT = new CompoundTag();
                this.scryTarget.saveAsPassenger(this.scryNBT);
                this.sendUpdates();
            }
            ++this.scryTimer;
        }
    }

    @Override
    public void mahoujinClientTick(Level level, BlockPos pos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        if (this.scryNBT == null) {
            this.scryTarget = null;
        }
        if (this.doRead && this.scryNBT != null) {
            EntityType zz = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)this.scryNBT.getString("id")));
            if (this.scryNBT != null && zz != null && zz == EntityType.PLAYER) {
                this.scryTarget = MahouTsukaiMod.proxy.getPlayerForScry(level, this.viewTarget, this.scryNBT, this.scryUniqueID);
            } else if (this.scryNBT != null && !this.scryNBT.isEmpty()) {
                try {
                    EntityType.create((CompoundTag)this.scryNBT, (Level)level).ifPresent(entity -> {
                        this.scryTarget = (LivingEntity)entity;
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.doRead = false;
        }
        if (this.scryTarget != null) {
            this.scryTarget.yHeadRot = this.hyaw;
            this.scryTarget.yHeadRotO = this.phyaw;
            this.scryTarget.setYRot(this.yaw);
            this.scryTarget.yRotO = this.pyaw;
            this.scryTarget.setXRot(this.pitch);
            this.scryTarget.xRotO = this.ppitch;
            this.scryTarget.yBodyRot = this.ryaw;
            this.scryTarget.yBodyRotO = this.pryaw;
            this.scryTarget.setDeltaMovement(new Vec3(this.velx, this.vely, this.velz));
            this.scryTarget.walkAnimation.position = this.limbSwing;
            this.scryTarget.walkAnimation.setSpeed(this.limbSwingAmount);
            this.scryTarget.attackAnim = this.swingProgress;
            this.scryTarget.oAttackAnim = this.prevSwingProgress;
            this.scryTarget.setPos(this.targetPos.x, this.targetPos.y, this.targetPos.z);
            this.prevSwingProgress = this.scryTarget.attackAnim;
            this.pyaw = this.scryTarget.getYRot();
            this.pryaw = this.scryTarget.yBodyRot;
            this.ppitch = this.scryTarget.getXRot();
            this.phyaw = this.scryTarget.yHeadRot;
            if (this.scryDataManager != null) {
                try {
                    this.scryTarget.getEntityData().assignValues(this.scryDataManager);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List<Item> checkForItem() {
        return Arrays.asList(Items.NAME_TAG, Items.BLAZE_POWDER, Items.ROTTEN_FLESH, Items.RABBIT_FOOT, (Item)ModItems.kodoku.get(), Items.GLOWSTONE_DUST, Items.ENDER_PEARL, Items.NETHER_WART);
    }

    @Override
    public List<Class<? extends Item>> checkForItemClass() {
        return Arrays.asList(SplashPotionItem.class);
    }

    @Override
    public int checkTicks() {
        return MTConfig.SCRYING_BLOCK_CYCLE;
    }

    @Override
    public boolean preConditions() {
        return ActiveCircleConfig.tryToOperate(this, this.getCasterUUID());
    }

    @Override
    public boolean firstEntityOnly() {
        return true;
    }

    @Override
    public boolean ifItemFoundAbove(ItemEntity item) {
        boolean changedName = this.nameTag(item);
        this.sympathetic(item);
        if (this.scryTarget == null || !this.scryTarget.isAlive() || changedName || this.doRead) {
            if (this.viewTarget != null && !this.viewTarget.equals("")) {
                Player e = ScryingMahoujinTileEntity.getPlayerByName(this.viewTarget, this.level);
                if (e == null && MTConfig.SCRY_NON_PLAYERS) {
                    HashSet<Entity> loaded = CommonProxy.getAllEntities((ServerLevel)this.level);
                    this.scryTarget = null;
                    if (loaded != null) {
                        for (Entity entity : loaded) {
                            if (entity.getCustomName() == null || !entity.getCustomName().getString().equals(this.viewTarget) || !(entity instanceof LivingEntity)) continue;
                            this.scryTarget = (LivingEntity)entity;
                            this.sendUpdates();
                            break;
                        }
                        if (this.scryTarget == null) {
                            for (Entity entity : loaded) {
                                if (!entity.getDisplayName().getString().equals(this.viewTarget) || !(entity instanceof LivingEntity)) continue;
                                this.scryTarget = (LivingEntity)entity;
                                this.sendUpdates();
                                break;
                            }
                        }
                    }
                } else {
                    this.scryTarget = e;
                    this.sendUpdates();
                }
            }
            if (this.scryTarget != null && !this.scryTarget.isAlive()) {
                this.scryTarget = null;
                this.sendUpdates();
            }
            this.doRead = false;
        }
        return false;
    }

    public List<SynchedEntityData.DataValue<?>> getAll(SynchedEntityData data, boolean checkDirty) {
        ArrayList<SynchedEntityData.DataValue> list = null;
        if (data.isDirty() || !checkDirty) {
            for (SynchedEntityData.DataItem dataitem : data.itemsById) {
                if (!dataitem.isDirty() && checkDirty) continue;
                dataitem.setDirty(false);
                if (list == null) {
                    list = new ArrayList<SynchedEntityData.DataValue>();
                }
                list.add(dataitem.value());
            }
        }
        return list;
    }

    public static Player getPlayerByName(String name, Level world) {
        Player ret = null;
        if (world != null) {
            for (Player p : world.players()) {
                if (!p.getName().getString().equals(name)) continue;
                ret = p;
            }
        }
        return ret;
    }

    public boolean nameTag(ItemEntity item) {
        boolean nearbyBatteriesGaveMana;
        Player caster = this.getCaster();
        boolean ret = false;
        if (item.getItem().getItem() == Items.NAME_TAG && ((nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.worldPosition, this.level, this.getCasterUUID(), MTConfig.SCRYING_MANA_COST)) || caster != null && PlayerManaManager.drainMana(caster, MTConfig.SCRYING_MANA_COST, false, false) == MTConfig.SCRYING_MANA_COST)) {
            String s = item.getItem().getHoverName().getString();
            this.viewTarget = s != null ? s : "";
            this.scryTimer = 0;
            ret = true;
            this.sendUpdates();
            item.discard();
        }
        return ret;
    }

    public void sympathetic(ItemEntity e) {
        IItemHandler inventory;
        BlockEntity down;
        double firechance = MTConfig.KODOKU_FIRE_CHANCE;
        double splashchance = MTConfig.KODOKU_SPLASH_CHANCE;
        double hungerchance = MTConfig.KODOKU_HUNGER_CHANCE;
        double hopchance = MTConfig.KODOKU_HOP_CHANCE;
        double glowchance = MTConfig.KODOKU_GLOW_CHANCE;
        double telechance = MTConfig.KODOKU_TELEPORT_CHANCE;
        double confusechance = MTConfig.KODOKU_CONFUSE_CHANCE;
        if (this.scryTarget != null && this.scryTarget.isAlive() && this.level != null && (down = this.level.getBlockEntity(this.worldPosition.relative(Direction.DOWN))) != null && (inventory = Utils.getInventory(this.level, this.worldPosition.relative(Direction.DOWN))) != null) {
            int kodoku = 0;
            int targetkodoku = MisfortunePotion.getMaxKodoku(this.scryTarget);
            ItemStack s = null;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                s = inventory.getStackInSlot(i);
                if (!(s.getItem() instanceof KodokuItem)) continue;
                kodoku = KodokuItem.getKodoku(s);
                break;
            }
            LivingEntity realTarget = this.scryTarget;
            if (targetkodoku > kodoku * 2) {
                realTarget = this.getCaster();
            } else {
                kodoku -= targetkodoku;
            }
            if (kodoku > 0 && s != null) {
                boolean success = false;
                boolean consume = false;
                boolean actualconsume = false;
                if (this.getCaster() != null) {
                    if (e.getItem().getItem() == Items.BLAZE_POWDER) {
                        if (this.getCaster().getRandom().nextDouble() < firechance * Math.sqrt(kodoku)) {
                            realTarget.igniteForSeconds(7.0f);
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    } else if (e.getItem().getItem() instanceof SplashPotionItem) {
                        if (this.getCaster().getRandom().nextDouble() < splashchance * Math.sqrt(kodoku)) {
                            ItemStack pot = e.getItem().split(1);
                            ThrownPotion entitypotion = new ThrownPotion(this.level, realTarget.getX(), realTarget.getY(), realTarget.getZ());
                            entitypotion.setItem(pot);
                            this.level.addFreshEntity((Entity)entitypotion);
                            success = true;
                        }
                        consume = true;
                    } else if (e.getItem().getItem() == Items.ROTTEN_FLESH) {
                        if (realTarget instanceof Player) {
                            if (this.getCaster().getRandom().nextDouble() < hungerchance * Math.sqrt(kodoku)) {
                                ((Player)realTarget).getFoodData().setFoodLevel(Math.max(((Player)realTarget).getFoodData().getFoodLevel() - 5, 0));
                                success = true;
                            }
                            consume = true;
                            actualconsume = true;
                        }
                    } else if (e.getItem().getItem() == Items.RABBIT_FOOT) {
                        if (this.getCaster().getRandom().nextDouble() < hopchance * Math.sqrt(kodoku)) {
                            realTarget.setDeltaMovement(realTarget.getDeltaMovement().x, (double)1.1f, realTarget.getDeltaMovement().z);
                            realTarget.hurtMarked = true;
                            realTarget.hasImpulse = true;
                            success = true;
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.getItem().getItem() == ModItems.kodoku.get()) {
                        if (KodokuItem.getKodoku(e.getItem()) > 0) {
                            EffectUtil.buff(realTarget, ModEffects.MISFORTUNE, true, 600, KodokuItem.getKodoku(e.getItem()));
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    } else if (e.getItem().getItem() == Items.GLOWSTONE_DUST) {
                        if (this.getCaster().getRandom().nextDouble() < glowchance * Math.sqrt(kodoku)) {
                            EffectUtil.buff(realTarget, (Holder<MobEffect>)MobEffects.GLOWING, true, 600);
                            success = true;
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.getItem().getItem() == Items.ENDER_PEARL) {
                        if (this.getCaster().getRandom().nextDouble() < telechance * Math.sqrt(kodoku)) {
                            if (!(realTarget instanceof Player) || ContractMahoujinTileEntity.isImmuneToSpell(realTarget.level(), this.getCasterUUID(), (Entity)realTarget)) {
                                MahouTsukaiTeleporter.teleport((Entity)realTarget, (double)this.worldPosition.getX() + 0.5, this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5, EffectUtil.getDimension(this.getCaster().level()));
                                success = true;
                            } else {
                                this.getCaster().displayClientMessage((Component)Component.translatable((String)"mahoutsukai.teleport_kodoku.failed"), true);
                                success = true;
                            }
                        }
                        actualconsume = true;
                        consume = true;
                    } else if (e.getItem().getItem() == Items.NETHER_WART) {
                        if (this.getCaster().getRandom().nextDouble() < confusechance * Math.sqrt(kodoku)) {
                            EffectUtil.buff(realTarget, ModEffects.CONFUSION, true, 240);
                            success = true;
                        }
                        consume = true;
                        actualconsume = true;
                    }
                    if (!success && consume) {
                        this.getCaster().displayClientMessage((Component)Component.translatable((String)"mahoutsukai.kodoku.failed"), true);
                    }
                    if (success) {
                        ((MahouTrigger)((Object)ModTriggers.KODOKU.get())).trigger((ServerPlayer)this.getCaster());
                    }
                    if (actualconsume) {
                        e.getItem().shrink(1);
                        s.shrink(1);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.scryTarget != null) {
            CompoundTag nbt = new CompoundTag();
            EntityType entitytype = this.scryTarget.getType();
            ResourceLocation resourcelocation = EntityType.getKey((EntityType)entitytype);
            nbt.putString("id", resourcelocation.toString());
            HashSet<String> toRemove = new HashSet<String>();
            this.scryTarget.saveWithoutId(nbt);
            for (String key : nbt.getAllKeys()) {
                Tag zz = nbt.get(key);
                if (zz != null && zz.toString().length() > 15000) {
                    toRemove.add(key);
                }
                if (!key.equals("ForgeCaps")) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                nbt.remove(key);
            }
            PacketHandler.sendTrackingBlock(this.getBlockPos(), this.level, new ScryingEntityPacket(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ(), Optional.of(nbt)));
        } else {
            PacketHandler.sendTrackingBlock(this.getBlockPos(), this.level, new ScryingEntityPacket(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ(), Optional.empty()));
        }
        return super.getUpdatePacket();
    }

    public class BlockPosInfo {
        public BlockState state;
        public BlockEntity te;

        public BlockPosInfo(ScryingMahoujinTileEntity this$0, BlockPos pos, Level world) {
            this.state = world.getBlockState(pos);
            this.te = null;
        }

        public BlockPosInfo(ScryingMahoujinTileEntity this$0) {
            this.state = null;
            this.te = null;
        }

        public CompoundTag write() {
            if (this.state.getBlock() == Blocks.AIR) {
                return new CompoundTag();
            }
            CompoundTag nbt = new CompoundTag();
            CompoundTag nbts = new CompoundTag();
            CompoundTag nbtte = new CompoundTag();
            if (this.state != null) {
                nbts = NbtUtils.writeBlockState((BlockState)this.state);
                nbt.put("SCRY_STATE", (Tag)nbts);
            }
            return nbt;
        }

        public void read(CompoundTag nbt, Level level) {
            if (nbt.contains("SCRY_STATE")) {
                this.state = NbtUtils.readBlockState((HolderGetter)level.holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("SCRY_STATE"));
            }
        }
    }
}

