/*
 * Decompiled with CFR 0.152.
 */
package wile.api.rca;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import wile.api.rca.RedstoneClientAdapter;
import wile.redstonepen.libmc.Auxiliaries;

public class FmmRedstoneClientAdapter {

    public static class Adapter
    implements RedstoneClientAdapter {
        private static final int ERROR_RELOAD_DELAY = 20;
        private static final int MAP_SIZE = 16;
        private static Adapter singletonInstance = null;
        private static boolean featureEnabled = true;
        private final FileMemMap inFile;
        private final FileMemMap outFile;
        private final int reopenDelay;
        private final boolean isSystemSide;
        private long inputDataWord = 0L;
        private long outputDataWord = 0L;
        private boolean inputDataChanged = false;
        private boolean outputDataChanged = true;
        private boolean ipcOpen = false;

        public static String ipcIoPath(boolean mcSideOutput) {
            return Auxiliaries.getGameDirectory().resolve("redstonepen." + (mcSideOutput ? (char)'o' : 'i') + ".mmap").toString();
        }

        public static boolean available() {
            return featureEnabled && singletonInstance != null;
        }

        public static Adapter instance() {
            if (!featureEnabled) {
                return null;
            }
            if (singletonInstance != null) {
                return singletonInstance;
            }
            try {
                if (!Files.exists(Path.of(Adapter.ipcIoPath(false), new String[0]), new LinkOption[0]) || !Files.exists(Path.of(Adapter.ipcIoPath(true), new String[0]), new LinkOption[0])) {
                    featureEnabled = false;
                } else {
                    singletonInstance = new Adapter(false);
                }
            }
            catch (Exception ignored) {
                featureEnabled = false;
            }
            return singletonInstance;
        }

        public Adapter(boolean systemSide) {
            this.isSystemSide = systemSide;
            this.reopenDelay = systemSide ? 0 : 20;
            this.inFile = new FileMemMap(Adapter.ipcIoPath(systemSide), false, this.reopenDelay, 16);
            this.outFile = new FileMemMap(Adapter.ipcIoPath(!systemSide), true, this.reopenDelay, 16);
        }

        @Override
        public long getInputs() {
            return this.inputDataWord;
        }

        @Override
        public void setInputs(long val) {
            if (val != this.inputDataWord) {
                this.inputDataWord = val;
                this.inputDataChanged = true;
            }
        }

        @Override
        public boolean isInputsChanged() {
            return this.inputDataChanged;
        }

        @Override
        public void setInputsChanged(boolean changed) {
            this.inputDataChanged = changed;
        }

        @Override
        public long getOutputs() {
            return this.outputDataWord;
        }

        @Override
        public void setOutputs(long val) {
            if (val != this.outputDataWord) {
                this.outputDataWord = val;
                this.outputDataChanged = true;
            }
        }

        @Override
        public boolean isOutputsChanged() {
            return this.outputDataChanged;
        }

        @Override
        public void setOutputsChanged(boolean changed) {
            this.outputDataChanged = changed;
        }

        @Override
        public boolean isOpen() {
            return this.ipcOpen;
        }

        @Override
        public void tick() {
            if (!this.ipcOpen) {
                if (this.isSystemSide) {
                    this.ipcOpen = this.inFile.open(true) && this.outFile.open(true);
                } else if (this.inFile.closed() || this.outFile.closed()) {
                    this.ipcOpen = this.inFile.open(false) && this.outFile.open(false);
                }
            } else {
                int i;
                long val;
                if (this.inFile.tick()) {
                    val = 0L;
                    for (i = 0; i < 16; ++i) {
                        val = val << 4 | (long)Adapter.hex2nibble(this.inFile.get(i));
                    }
                    if (val != this.inputDataWord) {
                        this.inputDataWord = val;
                        this.inputDataChanged = true;
                    }
                }
                if (this.outputDataChanged) {
                    val = this.outputDataWord;
                    for (i = 15; i >= 0; --i) {
                        byte b = Adapter.nibble2hex((int)(val & 0xFL));
                        this.outFile.set(i, b);
                        val >>= 4;
                    }
                    this.outputDataChanged = !this.outFile.tick();
                }
                this.ipcOpen = !this.inFile.closed() && !this.outFile.closed();
            }
        }

        private static int hex2nibble(byte b) {
            if (b >= 65 && b <= 70) {
                return b - 65 + 10;
            }
            if (b >= 97 && b <= 102) {
                return b - 97 + 10;
            }
            if (b >= 48 && b <= 57) {
                return b - 48;
            }
            return 0;
        }

        private static byte nibble2hex(int n) {
            if (n <= 0) {
                return 48;
            }
            if (n <= 9) {
                return (byte)(48 + n);
            }
            if (n <= 15) {
                return (byte)(97 + (n - 10));
            }
            return 48;
        }
    }

    private static class FileMemMap {
        private final String mapFilePath;
        private final int mapOffset;
        private final int mapSize;
        private final byte[] mapData;
        private final boolean isWrite;
        private final int reopenDelay;
        private RandomAccessFile file = null;
        private FileChannel channel = null;
        private MappedByteBuffer buffer = null;

        public FileMemMap(String path, boolean output, int reopen_delay, int size) {
            this.mapFilePath = path;
            this.reopenDelay = reopen_delay;
            this.isWrite = output;
            this.mapOffset = 0;
            this.mapSize = size;
            this.mapData = new byte[this.mapSize];
            Arrays.fill(this.mapData, (byte)48);
        }

        public String path() {
            return this.mapFilePath;
        }

        public int size() {
            return this.mapSize;
        }

        public byte[] data() {
            return this.mapData;
        }

        public byte get(int index) {
            return index < 0 || index >= this.size() ? (byte)0 : this.mapData[index];
        }

        public void set(int index, byte value) {
            if (index >= 0 && index < this.size()) {
                this.mapData[index] = value;
            }
        }

        public boolean closed() {
            return this.buffer == null || this.file == null;
        }

        public boolean open(boolean initialize) {
            if (this.mapOffset < 0 || this.size() <= 0 || this.size() > 4096) {
                return false;
            }
            this.close();
            try {
                if (initialize && (!Files.exists(Path.of(this.mapFilePath, new String[0]), new LinkOption[0]) || Files.size(Path.of(this.mapFilePath, new String[0])) < (long)this.size())) {
                    Files.write(Path.of(this.mapFilePath, new String[0]), this.mapData, new OpenOption[0]);
                }
                this.file = new RandomAccessFile(new File(this.mapFilePath), this.isWrite ? "rw" : "r");
                this.channel = this.file.getChannel();
                if (this.channel.size() < (long)this.size()) {
                    this.close();
                    return false;
                }
                this.buffer = this.channel.map(this.isWrite ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY, 0L, this.size());
                if (this.isWrite) {
                    this.buffer.clear().put(this.mapData);
                }
                return true;
            }
            catch (Throwable ex) {
                this.close();
                return false;
            }
        }

        public void close() {
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.channel = null;
            this.file = null;
            this.buffer = null;
        }

        public void remove() {
            try {
                boolean bl = new File(this.mapFilePath).delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean tick() {
            try {
                if (this.isWrite) {
                    this.buffer.clear().put(this.mapData);
                } else {
                    this.buffer.clear().get(this.mapData);
                }
                return true;
            }
            catch (Throwable ex) {
                this.close();
                return false;
            }
        }
    }
}

