/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.datacomponents;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.codec.EnumIndexCodec;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public abstract class AbstractPipeTypeData<T> {
    protected UpgradeTileEntity.FilterMode filterMode;
    protected UpgradeTileEntity.RedstoneMode redstoneMode;
    protected UpgradeTileEntity.Distribution distribution;
    protected List<Filter<?, T>> filters;

    public AbstractPipeTypeData(UpgradeTileEntity.FilterMode filterMode, UpgradeTileEntity.RedstoneMode redstoneMode, UpgradeTileEntity.Distribution distribution, @Nullable List<Filter<?, T>> filters) {
        this.filterMode = filterMode;
        this.redstoneMode = redstoneMode;
        this.distribution = distribution;
        this.filters = filters == null ? Collections.emptyList() : Collections.unmodifiableList(filters);
    }

    public UpgradeTileEntity.FilterMode getFilterMode() {
        return this.filterMode;
    }

    public UpgradeTileEntity.RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public UpgradeTileEntity.Distribution getDistribution() {
        return this.distribution;
    }

    public List<Filter<?, ?>> copyFilterList() {
        ArrayList filterList = new ArrayList(this.filters.size());
        for (Filter<?, T> filter : this.filters) {
            filterList.add((Filter<?, ?>)filter.copy());
        }
        return filterList;
    }

    public List<Filter<?, T>> copyFilterList2() {
        ArrayList filterList = new ArrayList(this.filters.size());
        for (Filter<?, T> filter : this.filters) {
            filterList.add((Filter<?, T>)filter.copy());
        }
        return filterList;
    }

    public abstract PipeTypeDataBuilder builder();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPipeTypeData that = (AbstractPipeTypeData)o;
        return this.filterMode == that.filterMode && this.redstoneMode == that.redstoneMode && this.distribution == that.distribution && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.filterMode);
        result = 31 * result + Objects.hashCode(this.redstoneMode);
        result = 31 * result + Objects.hashCode(this.distribution);
        result = 31 * result + Objects.hashCode(this.filters);
        return result;
    }

    public static <T, F extends Filter<?, T>, U extends AbstractPipeTypeData<T>> Codec<U> codec(Class<U> clazz, @Nullable Codec<F> filterCodec) {
        Constructor constructor;
        try {
            constructor = clazz.getDeclaredConstructor(UpgradeTileEntity.FilterMode.class, UpgradeTileEntity.RedstoneMode.class, UpgradeTileEntity.Distribution.class, List.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (filterCodec == null) {
            return RecordCodecBuilder.create(i -> i.group((App)EnumIndexCodec.of(UpgradeTileEntity.FilterMode.class).fieldOf("filter_mode").forGetter(AbstractPipeTypeData::getFilterMode), (App)EnumIndexCodec.of(UpgradeTileEntity.RedstoneMode.class).fieldOf("redstone_mode").forGetter(AbstractPipeTypeData::getRedstoneMode), (App)EnumIndexCodec.of(UpgradeTileEntity.Distribution.class).fieldOf("distribution").forGetter(AbstractPipeTypeData::getDistribution)).apply((Applicative)i, (filterMode, redstoneMode, distribution) -> {
                try {
                    return (AbstractPipeTypeData)constructor.newInstance(filterMode, redstoneMode, distribution, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return RecordCodecBuilder.create(i -> i.group((App)EnumIndexCodec.of(UpgradeTileEntity.FilterMode.class).fieldOf("filter_mode").forGetter(AbstractPipeTypeData::getFilterMode), (App)EnumIndexCodec.of(UpgradeTileEntity.RedstoneMode.class).fieldOf("redstone_mode").forGetter(AbstractPipeTypeData::getRedstoneMode), (App)EnumIndexCodec.of(UpgradeTileEntity.Distribution.class).fieldOf("distribution").forGetter(AbstractPipeTypeData::getDistribution), (App)filterCodec.listOf().fieldOf("Filters").forGetter(o -> o.filters)).apply((Applicative)i, (filterMode, redstoneMode, distribution, filters) -> {
            try {
                return (AbstractPipeTypeData)constructor.newInstance(filterMode, redstoneMode, distribution, filters);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static <T, F extends Filter<?, T>, U extends AbstractPipeTypeData<T>> StreamCodec<RegistryFriendlyByteBuf, U> streamCodec(Class<U> clazz, @Nullable StreamCodec<RegistryFriendlyByteBuf, F> filterCodec) {
        Constructor constructor;
        try {
            constructor = clazz.getDeclaredConstructor(UpgradeTileEntity.FilterMode.class, UpgradeTileEntity.RedstoneMode.class, UpgradeTileEntity.Distribution.class, List.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (filterCodec == null) {
            return StreamCodec.composite(EnumIndexCodec.ofStream(UpgradeTileEntity.FilterMode.class), AbstractPipeTypeData::getFilterMode, EnumIndexCodec.ofStream(UpgradeTileEntity.RedstoneMode.class), AbstractPipeTypeData::getRedstoneMode, EnumIndexCodec.ofStream(UpgradeTileEntity.Distribution.class), AbstractPipeTypeData::getDistribution, (filterMode, redstoneMode, distribution) -> {
                try {
                    return (AbstractPipeTypeData)constructor.newInstance(filterMode, redstoneMode, distribution, Collections.emptyList());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return StreamCodec.composite(EnumIndexCodec.ofStream(UpgradeTileEntity.FilterMode.class), AbstractPipeTypeData::getFilterMode, EnumIndexCodec.ofStream(UpgradeTileEntity.RedstoneMode.class), AbstractPipeTypeData::getRedstoneMode, EnumIndexCodec.ofStream(UpgradeTileEntity.Distribution.class), AbstractPipeTypeData::getDistribution, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, filterCodec), u -> u.filters, (filterMode, redstoneMode, distribution, filters) -> {
            try {
                return (AbstractPipeTypeData)constructor.newInstance(filterMode, redstoneMode, distribution, filters);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static abstract class PipeTypeDataBuilder<D extends AbstractPipeTypeData<T>, B extends PipeTypeDataBuilder<D, B, T>, T> {
        protected UpgradeTileEntity.FilterMode filterMode;
        protected UpgradeTileEntity.RedstoneMode redstoneMode;
        protected UpgradeTileEntity.Distribution distribution;
        protected List<Filter<?, T>> filters;

        public PipeTypeDataBuilder(D data) {
            this.filterMode = ((AbstractPipeTypeData)data).getFilterMode();
            this.redstoneMode = ((AbstractPipeTypeData)data).getRedstoneMode();
            this.distribution = ((AbstractPipeTypeData)data).getDistribution();
            this.filters = ((AbstractPipeTypeData)data).copyFilterList2();
        }

        public B filterMode(UpgradeTileEntity.FilterMode filterMode) {
            this.filterMode = filterMode;
            return (B)this;
        }

        public B redstoneMode(UpgradeTileEntity.RedstoneMode redstoneMode) {
            this.redstoneMode = redstoneMode;
            return (B)this;
        }

        public B distribution(UpgradeTileEntity.Distribution distribution) {
            this.distribution = distribution;
            return (B)this;
        }

        public B filters(List<Filter<?, T>> filters) {
            this.filters = filters;
            return (B)this;
        }

        public abstract D build();
    }
}

