/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.net;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.net.Message;
import de.maxhenkel.pipez.gui.ExtractContainer;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RemoveFilterMessage
implements Message<RemoveFilterMessage> {
    public static final CustomPacketPayload.Type<RemoveFilterMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pipez", (String)"remove_filter"));
    private UUID filter;
    private int index;

    public RemoveFilterMessage() {
    }

    public RemoveFilterMessage(UUID filter, int index) {
        this.filter = filter;
        this.index = index;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof ExtractContainer) {
            ExtractContainer extractContainer = (ExtractContainer)abstractContainerMenu;
            PipeType<?, ?> pipeType = extractContainer.getPipe().getPipeTypes()[this.index];
            List<Filter<?, ?>> filters = extractContainer.getPipe().getFilters(extractContainer.getSide(), pipeType);
            filters.removeIf(f -> f.getId().equals(this.filter));
            extractContainer.getPipe().setFilters(extractContainer.getSide(), pipeType, filters);
        }
    }

    @Override
    public RemoveFilterMessage fromBytes(RegistryFriendlyByteBuf packetBuffer) {
        this.filter = packetBuffer.readUUID();
        this.index = packetBuffer.readInt();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeUUID(this.filter);
        packetBuffer.writeInt(this.index);
    }

    @Override
    public CustomPacketPayload.Type<RemoveFilterMessage> type() {
        return TYPE;
    }
}

