/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jade;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.api.content.pipes.examples.EnergyPipeGraph;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public enum EnergyPipeServerDataProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        if (blockAccessor.getBlock() != MachinesContent.Block.PipeEnergy.block()) {
            return;
        }
        Player player = blockAccessor.getPlayer();
        if (!player.getItemInHand(InteractionHand.MAIN_HAND).is(MachinesContent.Item.Tablet.item()) && !player.getItemInHand(InteractionHand.OFF_HAND).is(MachinesContent.Item.Tablet.item())) {
            return;
        }
        Level level = blockAccessor.getLevel();
        BlockPos pos = blockAccessor.getPosition();
        PipeNetwork data = (PipeNetwork)level.getData(MachinesAttachments.Level.EnergyPipeNetwork);
        EnergyPipeGraph graph = (EnergyPipeGraph)data.getPipeGraph(pos.asLong());
        if (!(graph instanceof EnergyPipeGraph)) {
            return;
        }
        EnergyPipeGraph energyPipeGraph = graph;
        int color = ((DyeColors)MathUtils.fromArray((int)(Mth.abs((int)graph.id().hashCode()) % 4), (Object[])new DyeColors[]{DyeColors.LightBlue, DyeColors.Lime, DyeColors.Yellow})).getColor();
        compoundTag.putString("graph_id", graph.id().toString().substring(0, 13));
        compoundTag.putInt("pipe_count", graph.getRouteContainer().RouteGraph.vertexSet().size());
        compoundTag.putLong("stored", graph.getAllBuffers().stream().mapToLong(PipeGroup::getStored).sum());
        compoundTag.putString("handlers", String.valueOf(((ObjectArraySet)energyPipeGraph.getRouteContainer().PosToExternalCaches.get(pos.asLong())).stream().map(PipeRoute.CacheWrapper::getCapability).filter(Objects::nonNull).map(handler -> handler.getClass().getSimpleName()).toList()));
        compoundTag.putString("demands", String.valueOf(((ObjectArraySet)energyPipeGraph.getRouteContainer().PosToExternalCaches.get(pos.asLong())).stream().map(PipeRoute.CacheWrapper::getCapability).filter(Objects::nonNull).map(handler -> handler.receiveEnergy(Integer.MAX_VALUE, true)).toList()));
    }

    public boolean shouldRequestData(BlockAccessor accessor) {
        return super.shouldRequestData((Accessor)accessor);
    }

    public ResourceLocation getUid() {
        return XyCraft.resource((String)"energy_pipe_debug");
    }
}

