/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei.categories;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.PlayerStageAttachment;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.oldwidget.ImageWidget;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.compat.viewers.jei.categories.XyCategory;
import tv.soaryn.xycraft.machines.content.recipes.producers.centrifuge.CentrifugeRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class CentrifugeCategory
extends XyCategory<CentrifugeRecipe> {
    public static final RecipeType<CentrifugeRecipe> Type = new RecipeType(XyMachines.resource("centrifuge"), CentrifugeRecipe.class);
    int baseColor = -5605564;
    int glowColor = -3372971;
    private final ImageWidget _image = new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_full.png"), 67.0f, 34.0f, 16.0f, 16.0f, -1435011209);
    private final ImageWidget _imageGlow = new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_glow.png"), 67.0f, 34.0f, 16.0f, 16.0f, -1146443094);
    private final ImageWidget _image2 = new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_full.png"), 103.0f, 34.0f, 16.0f, 16.0f, this.baseColor);
    private final ImageWidget _image2Glow = new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_glow.png"), 103.0f, 34.0f, 16.0f, 16.0f, this.glowColor);
    private final ImageWidget _dot = new ImageWidget(null, XyCore.resource((String)"textures/gui/soft_dot.png"), 103.0f, 34.0f, 16.0f, 16.0f, this.glowColor);

    public CentrifugeCategory(IGuiHelper helper) {
        super("jei.xycraft.recipe.centrifuge", helper, Type, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)WorldContent.Item.XychoriumGem.get(XyCraftColors.Light))), helper.createBlankDrawable(140, 62), new Rectangle(0.0f, 0.0f, 140.0f, 62.0f));
    }

    public static void register(IRecipeRegistration registration) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList list = manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MachinesRecipeTypes.Centrifuge.type().get()).stream().map(RecipeHolder::value).collect(Collectors.toCollection(ArrayList::new));
        registration.addRecipes(Type, (List)list);
    }

    @Override
    public void drawSlots(@NotNull CentrifugeRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int slotTop = 7;
        int slotLeft = 15;
        int slotRight = (int)(this.getDimensions().width() - (float)slotLeft - 18.0f);
        int slotBottom = (int)(this.getDimensions().height() - (float)slotTop - 18.0f);
        int middleSlot = (int)(this.getDimensions().height() / 2.0f - 9.0f);
        guiGraphics.setColor(0.6f, 0.6f, 0.6f, 0.9f);
        slotUi.render(guiGraphics.pose(), (float)slotLeft, (float)middleSlot, 18.0f, 18.0f, 1.0f);
        slotUi.render(guiGraphics.pose(), (float)slotRight, (float)slotTop, 18.0f, 18.0f, 1.0f);
        if (recipe.outputB().isPresent()) {
            slotUi.render(guiGraphics.pose(), (float)slotRight, (float)slotBottom, 18.0f, 18.0f, 1.0f);
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        float dotScale = 0.25f;
        float arrowScale = 0.5f;
        this.renderDot(guiGraphics, (int)(this.getDimensions().width() / 2.0f - this._dot.getData().Dimensions.width() / 2.0f), (int)(this.getDimensions().height() / 2.0f - this._dot.getData().Dimensions.height() / 2.0f) - 1, 1.2f, -2004318072);
        int inputColor = -12277044;
        int inputGlowColor = -7816193;
        int middle = (int)(this.getDimensions().height() / 2.0f - this._image.getData().Dimensions.height() / 2.0f) - 1;
        this.renderArrow(guiGraphics, slotLeft + 19, middle, 0, arrowScale, inputColor, inputGlowColor);
        this.renderDot(guiGraphics, slotLeft + 25, middle, dotScale, inputGlowColor);
        this.renderArrow(guiGraphics, slotLeft + 31, middle, 0, arrowScale, inputColor, inputGlowColor);
        this.renderArrow(guiGraphics, slotRight - 14, slotTop, 0, arrowScale, this.baseColor, this.glowColor);
        this.renderDot(guiGraphics, slotRight - 20, slotTop, dotScale, this.glowColor);
        this.renderArrow(guiGraphics, slotRight - 26, slotTop, 0, arrowScale, this.baseColor, this.glowColor);
        this.renderDot(guiGraphics, slotRight - 32, slotTop, dotScale, this.glowColor);
        this.renderArrow(guiGraphics, slotRight - 36, slotTop + 4, -45, arrowScale, this.baseColor, this.glowColor);
        if (recipe.outputB().isPresent()) {
            this.renderArrow(guiGraphics, slotRight - 14, slotBottom, 0, arrowScale, this.baseColor, this.glowColor);
            this.renderDot(guiGraphics, slotRight - 20, slotBottom, dotScale, this.glowColor);
            this.renderArrow(guiGraphics, slotRight - 26, slotBottom, 0, arrowScale, this.baseColor, this.glowColor);
            this.renderDot(guiGraphics, slotRight - 32, slotBottom, dotScale, this.glowColor);
            this.renderArrow(guiGraphics, slotRight - 36, slotBottom - 4, 45, arrowScale, this.baseColor, this.glowColor);
        }
    }

    private void renderDot(GuiGraphics guiGraphics, int x, int y, float scale, int color) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        float u = this._dot.getData().Dimensions.width() / 2.0f;
        float v = this._dot.getData().Dimensions.height() / 2.0f;
        pose.translate(u, v, 0.0f);
        pose.scale(scale, scale, scale);
        pose.translate(-u, -v, 0.0f);
        this._dot.setColor(color);
        this._dot.render(guiGraphics, 0, 0, 0.0f);
        this._dot.render(guiGraphics, 0, 0, 0.0f);
        pose.popPose();
    }

    private void renderArrow(GuiGraphics guiGraphics, int x, int y, int rotation, float scale, int baseColor, int glowColor) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        float u = this._image.getData().Dimensions.width() / 2.0f;
        float v = this._image.getData().Dimensions.height() / 2.0f;
        pose.translate(u, v, 0.0f);
        pose.mulPose(new Quaternionf().rotationZ((float)Math.PI / 180 * (float)rotation));
        pose.scale(scale, scale, scale);
        pose.translate(-u, -v, 0.0f);
        this._image.setColor(baseColor);
        this._imageGlow.setColor(glowColor);
        this._image2.setColor(baseColor);
        this._image2Glow.setColor(glowColor);
        this._image.render(guiGraphics, 0, 0, 0.0f);
        this._imageGlow.render(guiGraphics, 0, 0, 0.0f);
        this._image2.render(guiGraphics, 0, 0, 0.0f);
        this._image2Glow.render(guiGraphics, 0, 0, 0.0f);
        pose.popPose();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, CentrifugeRecipe recipe, @NotNull IFocusGroup focuses) {
        Player player = Utils.getClientPlayer();
        if (recipe.requiredStage().isPresent() && player != null && !((PlayerStageAttachment)player.getData(CoreAttachments.PlayerStageData)).stages().getOrDefault((Object)recipe.requiredStage().get(), false)) {
            CentrifugeCategory.handleUnresearchedInput(builder, recipe.input());
            return;
        }
        int slotTop = 8;
        int slotLeft = 16;
        int middleSlot = (int)(this.getDimensions().height() / 2.0f - 9.0f) + 1;
        int slotRight = (int)(this.getDimensions().width() - (float)slotLeft - 18.0f) + 2;
        int slotBottom = (int)(this.getDimensions().height() - (float)slotTop - 18.0f) + 2;
        CentrifugeCategory.handleInputSlot(builder, slotLeft, middleSlot, recipe.input());
        CentrifugeCategory.handleOutputSlot(builder, slotRight, slotTop, recipe.outputA());
        if (recipe.outputB().isPresent()) {
            CentrifugeCategory.handleOutputSlot(builder, slotRight, slotBottom, recipe.outputB().get());
        }
    }
}

