/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;

public class ChargerAttachment
implements CommonCodecs.IItemContainerHolder {
    private static final Codec<ChargerAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommonCodecs.recordCodec((String)"inventory")).apply((Applicative)builder, ChargerAttachment::new));
    public static final AttachmentType.Builder<ChargerAttachment> BUILDER = AttachmentUtils.createBuilder(ChargerAttachment::new, CODEC, (data, holder) -> {
        data._blockEntity = (BlockEntity)holder;
    });
    public final ItemContainer Inventory = new ChargerContainer(this::setChanged);
    public final ItemContainer Input = this.Inventory.slice(0, 9);
    public final ItemContainer Output = this.Inventory.slice(9, 18);
    public final IItemHandler Handler = this.Inventory.asHandler(new HandlerIOBehavior(this){

        public boolean canInsert(int slot) {
            return slot < 9;
        }

        public boolean canExtract(int slot) {
            return slot >= 9;
        }
    });
    private BlockEntity _blockEntity;

    private ChargerAttachment(IAttachmentHolder holder) {
        if (holder instanceof BlockEntity) {
            BlockEntity entity;
            this._blockEntity = entity = (BlockEntity)holder;
        }
    }

    private ChargerAttachment(List<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            this.Inventory.set(i, inventory.get(i));
        }
    }

    private void setChanged() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }

    public ItemContainer getInventory() {
        return this.Inventory;
    }

    public static class ChargerContainer
    extends SimpleItemContainer {
        public ChargerContainer() {
            this(null);
        }

        public ChargerContainer(Runnable callback) {
            super(18, callback);
        }

        public boolean isValid(int slot, @NotNull ItemStack stack) {
            if (!super.isValid(slot, stack)) {
                return false;
            }
            return slot > 9 || stack.copyWithCount(1).getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }

        public int getSlotCapacity(int slot) {
            return slot < 9 ? 1 : super.getSlotCapacity(slot);
        }
    }
}

