/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.handlers.InfiniteFluidHandler;
import tv.soaryn.xycraft.machines.XyMachines;

public class WaterBlock
extends ColoredBlock
implements ITooltipProvider.BlockDefault {
    private final IFluidHandler source = new InfiniteFluidHandler((Fluid)Fluids.WATER);

    public WaterBlock(BlockBehaviour.Properties properties) {
        super((IColorSource)XyCraftColors.Blue, properties.randomTicks());
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource randSource) {
        super.randomTick(blockState, level, pos, randSource);
        VolumeLevelAttachment.add((Level)level, (BlockPos)pos, (Supplier)CoreAttachments.HydrationVolumeData);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!player.isCreative() && ((Boolean)XyMachines.ServerConfig.WaterBlockFillsContainer.get()).booleanValue()) {
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.source)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (stack.is(Items.GLASS_BOTTLE)) {
                if (!level.isClientSide()) {
                    Item item = stack.getItem();
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)));
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                    level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_54758_) {
        VolumeLevelAttachment.add((Level)level, (BlockPos)pos, (Supplier)CoreAttachments.HydrationVolumeData);
        WaterBlock.hardcodeTempFix(level, pos, pos.relative(Direction.UP));
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onRemove(state, level, pos, oldState, moving);
        level.invalidateCapabilities(pos);
        VolumeLevelAttachment.remove((Level)level, (BlockPos)pos, (Supplier)CoreAttachments.HydrationVolumeData);
    }

    public void neighborChanged(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean p_54714_) {
        WaterBlock.hardcodeTempFix(level, pos, neighborPos);
    }

    private static void hardcodeTempFix(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState fluidBlock;
        FluidState fluidState;
        if (!FluidInteractionRegistry.canInteract((Level)level, (BlockPos)pos) && (fluidState = (fluidBlock = level.getBlockState(neighborPos)).getFluidState()).is(FluidTags.LAVA)) {
            Block b = fluidState.isSource() ? Blocks.OBSIDIAN : Blocks.STONE;
            level.setBlockAndUpdate(neighborPos, b.defaultBlockState());
            level.levelEvent(1501, neighborPos, 0);
        }
    }
}

