/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.extractor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.machines.content.attachments.ExtractorAttachment;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class ExtractorBlockEntity
extends XyBlockEntity
implements ExtractorRecipe.Input {
    public ExtractorBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Block.Extractor.entity(), pos, state, new AttachmentType[0]);
        this.updatePositions();
    }

    public void updatePositions() {
        ExtractorAttachment data = (ExtractorAttachment)this.getData(MachinesAttachments.Block.ExtractorData);
        Direction direction = (Direction)this.getBlockState().getValue((Property)CoreStateProperties.StateDirection);
        data.setTargetPos(this.getBlockPos().relative(direction));
        data.setCatalystPos(this.getBlockPos().relative(direction, 2));
        data.setAdjacentPos(List.of(this.getAdjacentBlockPos(direction)));
        this.setChanged();
    }

    public BlockPos[] getAdjacentBlockPos(Direction direction) {
        BlockPos[] positions = new BlockPos[4];
        BlockPos pos = this.getBlockPos().relative(direction);
        int i = 0;
        for (Direction d : Direction.values()) {
            if (d.getAxis() == direction.getAxis()) continue;
            positions[i++] = pos.relative(d);
        }
        return positions;
    }

    public void onLoad() {
        this.updatePositions();
        super.onLoad();
    }

    public void setBlockState(@NotNull BlockState state) {
        super.setBlockState(state);
        if (this.level != null) {
            this.onLoad();
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)CoreStateProperties.StateDirection);
    }

    @Override
    public FluidState getFluidState() {
        return (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.defaultFluidState() : Fluids.EMPTY.defaultFluidState();
    }

    @Override
    public BlockState getTarget() {
        assert (this.level != null);
        return this.level.getBlockState(((ExtractorAttachment)this.getData(MachinesAttachments.Block.ExtractorData)).getTargetPos());
    }

    @Override
    public BlockState getCatalyst() {
        assert (this.level != null);
        return this.level.getBlockState(((ExtractorAttachment)this.getData(MachinesAttachments.Block.ExtractorData)).getCatalystPos());
    }

    @Override
    public List<BlockState> computeAdjacent() {
        assert (this.level != null);
        return ((ExtractorAttachment)this.getData(MachinesAttachments.Block.ExtractorData)).getAdjacentPos().stream().map(pos -> this.level.getBlockState(pos)).collect(Collectors.toCollection(ArrayList::new));
    }

    @Deprecated
    public static Iterable<BlockPos> areaInFront(BlockPos origin, Direction direction) {
        if (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            return BlockPos.betweenClosed((BlockPos)origin.offset(-1, -1, -1).relative(direction, 2), (BlockPos)origin.offset(1, 1, 1));
        }
        return BlockPos.betweenClosed((BlockPos)origin.offset(-1, -1, -1), (BlockPos)origin.offset(1, 1, 1).relative(direction, 2));
    }
}

