/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.network.CBPipeUpdatePacket;

public final class PipeConnectionAttachment {
    public static final Codec<PipeConnectionAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.tupleOf((Codec)Direction.CODEC, (Codec)PipeConnectionType.CODEC, Reference2ReferenceOpenHashMap::new).fieldOf("connection_logic_map").forGetter(PipeConnectionAttachment::map)).apply((Applicative)builder, PipeConnectionAttachment::new));
    public static final AttachmentType.Builder<PipeConnectionAttachment> builder = AttachmentType.builder(PipeConnectionAttachment::new).serialize(CODEC);
    private final Reference2ReferenceOpenHashMap<Direction, PipeConnectionType> _connections;

    public PipeConnectionAttachment(IAttachmentHolder holder) {
        this._connections = Direction.stream().collect(Collectors.toMap(Function.identity(), d -> PipeConnectionType.None, (pipeConnectionLogic, pipeConnectionLogic2) -> pipeConnectionLogic, Reference2ReferenceOpenHashMap::new));
    }

    public PipeConnectionAttachment(Reference2ReferenceOpenHashMap<Direction, PipeConnectionType> connections) {
        this._connections = connections;
    }

    public void set(Direction direction, PipeConnectionType logic) {
        this._connections.put((Object)direction, (Object)logic);
    }

    public void sendPacket(Level level, BlockPos pos, boolean invalidate) {
        if (!level.isClientSide()) {
            XyMachines.Network.broadcast(level, pos, (Packet.ClientBound)new CBPipeUpdatePacket(pos, (Reference2ReferenceMap<Direction, PipeConnectionType>)this.map()));
        }
        if (invalidate) {
            level.invalidateCapabilities(pos);
        }
    }

    public Reference2ReferenceOpenHashMap<Direction, PipeConnectionType> map() {
        return this._connections;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PipeConnectionAttachment that = (PipeConnectionAttachment)obj;
        return Objects.equals(this._connections, that._connections);
    }

    public int hashCode() {
        return Objects.hash(this._connections);
    }

    public String toString() {
        return "[%s]".formatted(this._connections);
    }
}

