/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.logic;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface VeinSearch {
    public static final List<BlockPos> Size3 = (List)Util.make(new ArrayList(), blockPos -> {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    blockPos.add(new BlockPos(x, y, z));
                }
            }
        }
    });
    public static final List<BlockPos> CropCorrection = (List)Util.make(new ArrayList(), blockPos -> {
        blockPos.add(new BlockPos(0, 1, 0));
        blockPos.add(new BlockPos(0, -1, 0));
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                blockPos.add(new BlockPos(x, 0, z));
            }
        }
    });

    public static void walk(Level level, BlockPos originPoint, HashSet<BlockPos> known, int maxBlocks, boolean cropLike, BlockValidator validator) {
        HashSet<BlockPos> traversed = new HashSet<BlockPos>(known);
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(originPoint);
        traversed.add(originPoint);
        while (!openSet.isEmpty()) {
            BlockState checkedState;
            BlockPos ptr = (BlockPos)openSet.pop();
            if (!validator.validate(ptr, checkedState = level.getBlockState(ptr)) || !known.add(ptr)) continue;
            if (known.size() >= maxBlocks) {
                return;
            }
            for (BlockPos side : cropLike ? CropCorrection : Size3) {
                BlockPos offset = ptr.offset((Vec3i)side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    @FunctionalInterface
    public static interface BlockValidator {
        public boolean validate(BlockPos var1, BlockState var2);
    }
}

