/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.tank;

import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankOperation;

public interface FluidAmountContainer {
    public int getCapacity();

    public int getFluidAmount();

    public void setFluidAmount(int var1, TankOperation var2);

    public static int getGCD(Iterable<? extends FluidAmountContainer> containers) {
        int gcd = 0;
        for (FluidAmountContainer fluidAmountContainer : containers) {
            int capacity = fluidAmountContainer.getCapacity();
            gcd = gcd != 0 ? MathUtils.gcd((int)gcd, (int)capacity) : capacity;
        }
        return gcd;
    }

    public static long getCapacity(Iterable<? extends FluidAmountContainer> containers) {
        long capacity = 0L;
        for (FluidAmountContainer fluidAmountContainer : containers) {
            capacity += (long)fluidAmountContainer.getCapacity();
        }
        return capacity;
    }

    public static long getFluidAmount(Iterable<? extends FluidAmountContainer> containers) {
        long amount = 0L;
        for (FluidAmountContainer fluidAmountContainer : containers) {
            amount += (long)fluidAmountContainer.getFluidAmount();
        }
        return amount;
    }

    public static void distribute(Iterable<? extends FluidAmountContainer> containers, long capacity, long gcd, long amount, TankOperation operation) {
        if (amount == 0L) {
            for (FluidAmountContainer fluidAmountContainer : containers) {
                fluidAmountContainer.setFluidAmount(0, operation);
            }
            return;
        }
        if (amount == capacity) {
            for (FluidAmountContainer fluidAmountContainer : containers) {
                fluidAmountContainer.setFluidAmount(fluidAmountContainer.getCapacity(), operation);
            }
            return;
        }
        long minFluidPerLayer = capacity / gcd;
        long layers = amount / minFluidPerLayer;
        long leftoverMilliBuckets = amount % minFluidPerLayer;
        for (FluidAmountContainer fluidAmountContainer : containers) {
            long fluidPerLayer = (long)fluidAmountContainer.getCapacity() / gcd;
            long leftoverMilliBucketsInSection = Math.min(leftoverMilliBuckets, fluidPerLayer);
            fluidAmountContainer.setFluidAmount((int)(fluidPerLayer * layers + (leftoverMilliBuckets -= leftoverMilliBucketsInSection)), operation);
        }
    }
}

