/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.tank;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.multiblock.CuboidDescriptor;
import tv.soaryn.xycraft.core.utils.multiblock.FormationRules;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.level.MultiTankLevelAttachment;
import tv.soaryn.xycraft.machines.content.multiblock.tank.FluidAmountContainer;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IMultiTankMember;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IOGroup;
import tv.soaryn.xycraft.machines.content.multiblock.tank.MultiTank;
import tv.soaryn.xycraft.machines.content.multiblock.tank.MultiTankFormationRules;
import tv.soaryn.xycraft.machines.content.multiblock.tank.MultiTankItemHandlerIOBehavior;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankOperation;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.gui.TankMenu;
import tv.soaryn.xycraft.machines.network.CBClientTankSyncPacket;
import tv.soaryn.xycraft.machines.network.CBTankFluidUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBTankFormPacket;
import tv.soaryn.xycraft.machines.network.CBTankUnformPacket;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class TankMultiBlock
implements FluidAmountContainer,
CommonCodecs.IItemContainerHolder {
    public static final FormationRules FORMATION_RULES = new MultiTankFormationRules();
    public static final int SLOT_COUNT = 4;
    private MultiTank parent;
    public final int id;
    private final int seed;
    private final CuboidDescriptor descriptor;
    private final int height;
    private final Long2ObjectOpenHashMap<BlockCapabilityCache<IMultiTankMember, Void>> memberCache = new Long2ObjectOpenHashMap();
    private final int capacity;
    private final int layerCapacity;
    private int fluidAmount;
    private final FluidHandler fluidHandler;
    private final ItemContainer inventory;
    private final IItemHandler fillItemHandler;
    private final IItemHandler drainItemHandler;
    private final IOGroup ioGroup;
    public static final Codec<TankMultiBlock> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("id").forGetter(data -> data.id), (App)CuboidDescriptor.CODEC.fieldOf("descriptor").forGetter(TankMultiBlock::getDescriptor), (App)Codec.INT.fieldOf("fluid_amount").forGetter(TankMultiBlock::getFluidAmount), (App)CommonCodecs.recordCodec((String)"inventory"), (App)NeoForgeExtraCodecs.setOf((Codec)Codec.LONG).xmap(LongArraySet::new, LongArraySet::new).fieldOf("members").forGetter(data -> new LongArraySet(data.memberCache.keySet()))).apply((Applicative)builder, TankMultiBlock::new));
    private boolean toggle = false;
    private int _redstoneValue = 0;
    private static final Set<TankMultiBlock> TO_VALIDATE = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<TankMultiBlock> TO_SYNC = Collections.newSetFromMap(new IdentityHashMap());
    private static boolean VALIDATING = false;

    public MultiTank getParent() {
        return this.parent;
    }

    TankMultiBlock(int id, CuboidDescriptor descriptor, int fluidAmount, List<ItemStack> items, LongArraySet positions) {
        this.id = id;
        this.seed = descriptor.min().hashCode();
        this.descriptor = descriptor;
        this.height = descriptor.max().getY() - descriptor.min().getY() - 1;
        this.capacity = TankMultiBlock.calculateCapacity(descriptor);
        this.layerCapacity = this.capacity / this.height;
        this.fluidHandler = new FluidHandler();
        this.inventory = new Container();
        for (int i = 0; i < items.size(); ++i) {
            this.inventory.set(i, items.get(i).copy());
        }
        this.fluidAmount = fluidAmount;
        this.fillItemHandler = this.inventory.slice(0, 2).asHandler((HandlerIOBehavior)MultiTankItemHandlerIOBehavior.INSTANCE);
        this.drainItemHandler = this.inventory.slice(2, 4).asHandler((HandlerIOBehavior)MultiTankItemHandlerIOBehavior.INSTANCE);
        this.ioGroup = new Section.Group(List.of(new Section()));
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long position = (Long)longIterator.next();
            this.memberCache.put(position, null);
        }
    }

    TankMultiBlock(MultiTank parent, int id, CuboidDescriptor descriptor, Long2ObjectOpenHashMap<BlockCapabilityCache<IMultiTankMember, Void>> members) {
        this.parent = parent;
        this.id = id;
        this.seed = descriptor.min().hashCode();
        this.descriptor = descriptor;
        this.height = descriptor.max().getY() - descriptor.min().getY() - 1;
        this.memberCache.putAll(members);
        this.capacity = TankMultiBlock.calculateCapacity(descriptor);
        this.layerCapacity = this.capacity / this.height;
        this.fluidHandler = new FluidHandler();
        this.inventory = new Container();
        this.fillItemHandler = this.inventory.slice(0, 2).asHandler((HandlerIOBehavior)MultiTankItemHandlerIOBehavior.INSTANCE);
        this.drainItemHandler = this.inventory.slice(2, 4).asHandler((HandlerIOBehavior)MultiTankItemHandlerIOBehavior.INSTANCE);
        this.ioGroup = new Section.Group(List.of(new Section()));
    }

    public void initialize(MultiTank parent) {
        this.parent = parent;
        for (Long2ObjectMap.Entry entry : this.memberCache.long2ObjectEntrySet()) {
            long value = entry.getLongKey();
            BlockCapabilityCache cache = BlockCapabilityCache.create(IMultiTankMember.BLOCK, (ServerLevel)this.getParent().getLevel(), (BlockPos)BlockPos.of((long)value), null);
            cache.getCapability();
            this.memberCache.put(value, (Object)cache);
            parent.getLevel().invalidateCapabilities(BlockPos.of((long)value));
        }
    }

    public static void tryForm(ServerLevel level, BlockPos valvePos, Direction clickedSide, ServerPlayer serverPlayer) {
        BlockPos innerPos = valvePos.relative(clickedSide.getOpposite());
        Either descriptor = CuboidDescriptor.tryFormOutwards((BlockGetter)level, (BlockPos)innerPos, (FormationRules)FORMATION_RULES);
        descriptor.map(desc -> {
            Long2ObjectOpenHashMap members = BlockPos.betweenClosedStream((BlockPos)desc.min(), (BlockPos)desc.max()).filter(blockPos -> level.getCapability(IMultiTankMember.BLOCK, blockPos, null) != null).collect(Long2ObjectOpenHashMap::new, (map, blockPos) -> map.put(blockPos.asLong(), (Object)BlockCapabilityCache.create(IMultiTankMember.BLOCK, (ServerLevel)level, (BlockPos)blockPos, null)), Long2ObjectOpenHashMap::putAll);
            Set otherTanks = members.long2ObjectEntrySet().stream().map(Map.Entry::getValue).map(BlockCapabilityCache::getCapability).filter(Objects::nonNull).flatMap(m -> StreamSupport.stream(m.getMultiBlocks().spliterator(), false)).collect(Collectors.toSet());
            Set otherMultiTanks = otherTanks.stream().map(m -> m.parent).collect(Collectors.toSet());
            if (otherMultiTanks.stream().anyMatch(MultiTank::isValid)) {
                serverPlayer.displayClientMessage((Component)Component.literal((String)"A valve is part of another tank. Balancing is not yet supported."), true);
                return false;
            }
            FluidStack fluidType = otherMultiTanks.stream().map(MultiTank::getFluidType).filter(Predicate.not(FluidStack::isEmpty)).reduce(FluidStack.EMPTY, TankMultiBlock::match);
            if (fluidType == null) {
                serverPlayer.displayClientMessage((Component)Component.literal((String)"Multiple fluids found. Nope."), true);
                return false;
            }
            MultiTankLevelAttachment cache = (MultiTankLevelAttachment)level.getData(MachinesAttachments.Level.LevelTankData);
            otherMultiTanks.stream().filter(Predicate.not(MultiTank::isValid)).forEach(multiTank -> cache.removeTank(multiTank.getId()));
            MultiTank multiTank2 = MultiTank.create(level);
            TankMultiBlock multiBlock = multiTank2.addSubTank((CuboidDescriptor)desc, (Long2ObjectOpenHashMap<BlockCapabilityCache<IMultiTankMember, Void>>)members);
            if (!fluidType.isEmpty()) {
                int inserted;
                multiTank2.setFluidType(fluidType.copy());
                int fluidInOtherTanks = otherTanks.stream().mapToInt(t -> t.fluidAmount).sum();
                multiBlock.fluidAmount = inserted = Math.min(fluidInOtherTanks, multiBlock.capacity);
                for (TankMultiBlock otherTank : otherTanks) {
                    int extracted = Math.min(inserted, otherTank.fluidAmount);
                    otherTank.fluidAmount -= extracted;
                    if ((inserted -= extracted) != 0) continue;
                    break;
                }
            }
            multiBlock.memberCache.values().stream().map(BlockCapabilityCache::getCapability).filter(Objects::nonNull).forEach(iMultiTankMember -> iMultiTankMember.onJoin(multiBlock));
            XyMachines.Network.broadcast((Level)level, desc.min(), (Packet.ClientBound)new CBTankFormPacket(desc.min(), desc.max(), multiBlock.getFluidHandler().getFluidInTank(0)));
            serverPlayer.displayClientMessage((Component)Component.literal((String)"Formed!"), true);
            return true;
        }, error -> {
            serverPlayer.displayClientMessage((Component)Component.literal((String)error), true);
            return false;
        });
    }

    public static FluidStack match(FluidStack a, FluidStack b) {
        if (a == null) {
            return FluidStack.EMPTY;
        }
        if (a.isEmpty()) {
            return b;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)a, (FluidStack)b) ? a : null;
    }

    public Long2ObjectOpenHashMap<BlockCapabilityCache<IMultiTankMember, Void>> getMembers() {
        return this.memberCache;
    }

    private static int calculateCapacity(CuboidDescriptor descriptor) {
        BlockPos innerVolume = descriptor.max().subtract((Vec3i)descriptor.min()).offset(-1, -1, -1);
        int volume = innerVolume.getX() * innerVolume.getY() * innerVolume.getZ();
        return (Integer)XyMachines.ServerConfig.TankStoragePerBlock.get() * volume;
    }

    public CuboidDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getFluidAmount() {
        return this.fluidAmount;
    }

    @Override
    public void setFluidAmount(int fluidAmount, TankOperation operation) {
        this.fluidAmount = fluidAmount;
        TO_SYNC.add(this);
    }

    public boolean isValid() {
        return this.parent.isValid();
    }

    public ItemContainer getInventory() {
        return this.inventory;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IItemHandler getFillItemHandler() {
        return this.fillItemHandler;
    }

    public IItemHandler getDrainItemHandler() {
        return this.drainItemHandler;
    }

    private int getBottom() {
        return this.descriptor.min().getY() + 1;
    }

    public int getHeight() {
        return this.height;
    }

    private int getLayerCapacity() {
        return this.layerCapacity;
    }

    public boolean canAccess(Player player) {
        if (!this.isValid()) {
            return false;
        }
        return AABB.encapsulatingFullBlocks((BlockPos)this.descriptor.min().offset(-8, -8, -8), (BlockPos)this.descriptor.max().offset(8, 8, 8)).intersects(player.getBoundingBox());
    }

    private Iterable<IOGroup> getMultiTankFillOrder() {
        return List.of(this.ioGroup);
    }

    private Iterable<IOGroup> getMultiTankDrainOrder() {
        return List.of(this.ioGroup);
    }

    public void onClickedClient(ServerPlayer player, BlockPos clickedPos, InteractionHand hand) {
        if (!this.canAccess((Player)player)) {
            return;
        }
        Block block = this.parent.getLevel().getBlockState(clickedPos).getBlock();
        if (block == MachinesContent.Block.Valve.block() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getFluidHandler())) {
            player.swing(hand, true);
            return;
        }
        if (block == MachinesContent.Block.ItemIo.block() && WrenchCapability.isValidToolInMainHand((Player)player, (InteractionHand)hand, (boolean)false)) {
            player.swing(hand, true);
            return;
        }
        TankMenu.open(player, this);
        player.swing(hand, true);
    }

    public Direction.Axis determineAxis(BlockPos pos) {
        BlockPos minTest = this.descriptor.min().subtract((Vec3i)pos);
        BlockPos maxTest = this.descriptor.max().subtract((Vec3i)pos);
        Vector3f minVector = new Vector3f((float)minTest.getX(), (float)minTest.getY(), (float)minTest.getZ());
        int minTestComponent = new Vector3f((float)minTest.getX(), (float)minTest.getY(), (float)minTest.getZ()).minComponent();
        float minComponentValue = minVector.get(minTestComponent);
        int maxTestComponent = new Vector3f((float)maxTest.getX(), (float)maxTest.getY(), (float)maxTest.getZ()).minComponent();
        return Direction.Axis.values()[minComponentValue == 0.0f ? minTestComponent : maxTestComponent];
    }

    @NotNull
    private BlockPos getCenter() {
        return new BlockPos((this.descriptor.min().getX() + this.descriptor.max().getX()) / 2, (this.descriptor.min().getY() + this.descriptor.max().getY()) / 2, (this.descriptor.min().getZ() + this.descriptor.max().getZ()) / 2);
    }

    public void tick() {
        int currentRedstone;
        int frequency = 5;
        long partial = ((long)this.seed + this.parent.getLevel().getGameTime()) % (long)frequency;
        if (partial == 0L) {
            if (this.toggle) {
                this.drainItem();
            } else {
                this.fillItem();
            }
            boolean bl = this.toggle = !this.toggle;
        }
        if ((currentRedstone = TankMultiBlock.redstoneLevelFromContents(this.fluidAmount, this.capacity)) != this._redstoneValue) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            ServerLevel level = this.getParent().getLevel();
            for (long l : this.memberCache.keySet().toLongArray()) {
                pos.set(l);
                level.updateNeighbourForOutputSignal((BlockPos)pos, level.getBlockState((BlockPos)pos).getBlock());
            }
        }
        this._redstoneValue = currentRedstone;
    }

    public static int redstoneLevelFromContents(int amount, int capacity) {
        double fractionFull = capacity == 0 ? 0.0 : (double)amount / (double)capacity;
        return Mth.floor((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    private void drainItem() {
        ItemStack input = this.inventory.get(0);
        ItemStack output = this.inventory.get(1);
        if (input.isEmpty()) {
            return;
        }
        if (!(output.isEmpty() || output.isStackable() && output.getMaxStackSize() > output.getCount())) {
            return;
        }
        int availableCapacity = this.capacity - this.fluidAmount;
        ItemStack inputSingle = input.getCount() == 1 ? input : input.copyWithCount(1);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputSingle, (IFluidHandler)this.getFluidHandler(), (int)availableCapacity, null, (boolean)false);
        if (!result.isSuccess() || !output.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)result.getResult(), (ItemStack)output)) {
            return;
        }
        result = FluidUtil.tryEmptyContainer((ItemStack)inputSingle, (IFluidHandler)this.getFluidHandler(), (int)availableCapacity, null, (boolean)true);
        if (!result.isSuccess()) {
            return;
        }
        if (inputSingle != input) {
            input.shrink(1);
            this.inventory.set(0, input);
        } else {
            this.inventory.set(0, ItemStack.EMPTY);
        }
        if (output.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result.getResult(), (ItemStack)output)) {
            if (!output.isEmpty()) {
                output.grow(result.getResult().getCount());
                this.inventory.set(1, output);
            } else {
                this.inventory.set(1, result.getResult());
            }
        } else {
            XyMachines.Logger.error("[TANK] Fluid extraction: Execution did not match simulation.");
            Block.popResource((Level)this.parent.getLevel(), (BlockPos)this.getCenter(), (ItemStack)result.getResult());
        }
    }

    private void fillItem() {
        IFluidHandler handler;
        ItemStack input = this.inventory.get(2);
        ItemStack output = this.inventory.get(3);
        if (input.isEmpty()) {
            return;
        }
        if (!(output.isEmpty() || output.isStackable() && output.getMaxStackSize() > output.getCount())) {
            return;
        }
        ItemStack inputSingle = input.getCount() == 1 ? input : input.copyWithCount(1);
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)inputSingle, (IFluidHandler)(handler = this.getFluidHandler()), (int)this.fluidAmount, null, (boolean)false);
        if (!result.isSuccess() || !output.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)result.getResult(), (ItemStack)output)) {
            return;
        }
        result = FluidUtil.tryFillContainer((ItemStack)inputSingle, (IFluidHandler)handler, (int)this.fluidAmount, null, (boolean)true);
        if (!result.isSuccess()) {
            return;
        }
        if (inputSingle != input) {
            input.shrink(1);
            this.inventory.set(2, input);
        } else {
            this.inventory.set(2, ItemStack.EMPTY);
        }
        if (output.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result.getResult(), (ItemStack)output)) {
            if (!output.isEmpty()) {
                output.grow(result.getResult().getCount());
                this.inventory.set(3, output);
            } else {
                this.inventory.set(3, result.getResult());
            }
        } else {
            XyMachines.Logger.error("[TANK] Fluid insertion: Execution did not match simulation.");
            Block.popResource((Level)this.parent.getLevel(), (BlockPos)this.getCenter(), (ItemStack)result.getResult());
        }
    }

    private void sync() {
        XyMachines.Network.broadcast((Level)this.parent.getLevel(), this.descriptor.min(), (Packet.ClientBound)new CBTankFluidUpdatePacket(this.descriptor.min(), this.getFluidHandler().getFluidInTank(0)));
    }

    private void validate() {
        this.descriptor.checkForErrors((BlockGetter)this.parent.getLevel(), FORMATION_RULES).ifPresent(error -> {
            this.parent.removeSubTank(this.id);
            this.memberCache.values().stream().map(BlockCapabilityCache::getCapability).filter(Objects::nonNull).forEach(iMultiTankMember -> iMultiTankMember.onLeave(this));
            XyMachines.Network.broadcast((Level)this.parent.getLevel(), (Packet.ClientBound)new CBTankUnformPacket(this.descriptor.min()));
            BlockPos center = this.getCenter();
            for (ItemStack stack : this.inventory) {
                if (stack.isEmpty()) continue;
                Block.popResource((Level)this.parent.getLevel(), (BlockPos)center, (ItemStack)stack);
            }
        });
    }

    public static <T> Stream<T> findAll(Level level, BlockPos pos, Class<T> type) {
        return FastVolumeLookup.of((Level)level, type).find(pos);
    }

    public static <T> Optional<T> find(Level level, BlockPos pos, Class<T> type) {
        return TankMultiBlock.findAll(level, pos, type).findFirst();
    }

    public static Optional<TankMultiBlock> getAt(ServerLevel level, BlockPos origin) {
        return TankMultiBlock.findAll((Level)level, origin, TankMultiBlock.class).filter(tank -> tank.descriptor.min().equals((Object)origin)).findFirst();
    }

    @SubscribeEvent
    private static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (player.isSecondaryUseActive() || ModifierKey.of((Player)player)) {
            return;
        }
        BlockState state = level.getBlockState(event.getHitVec().getBlockPos());
        Block block = state.getBlock();
        if (WrenchCapability.isValidToolInMainHand((Player)player, (InteractionHand)event.getHand(), (boolean)false) && block != MachinesContent.Block.Valve.block() && block == MachinesContent.Block.ItemIo.block()) {
            return;
        }
        TankMultiBlock.find(event.getLevel(), event.getPos(), TankMultiBlock.class).ifPresent(tank -> {
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide()));
            event.setCanceled(true);
        });
    }

    @SubscribeEvent
    private static void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        if (VALIDATING) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            FastVolumeLookup.of((Level)level, TankMultiBlock.class).find(event.getPos()).forEach(TO_VALIDATE::add);
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Sent event) {
        FastVolumeLookup lookup = FastVolumeLookup.of((Level)event.getLevel(), TankMultiBlock.class);
        ChunkPos chunkPos = event.getPos();
        FastVolumeLookup.ChunkVolumeData volumes = lookup.getVolumesForChunk(ChunkPos.asLong((int)chunkPos.x, (int)chunkPos.z));
        if (volumes == null) {
            return;
        }
        volumes.getAll().forEach(tankMultiBlock -> XyMachines.Network.send((Player)event.getPlayer(), (Packet.ClientBound)new CBClientTankSyncPacket(tankMultiBlock.descriptor, tankMultiBlock.getFluidHandler().getFluidInTank(0))));
    }

    @SubscribeEvent
    private static void onServerTickEnd(ServerTickEvent.Post event) {
        try {
            VALIDATING = true;
            TO_VALIDATE.forEach(TankMultiBlock::validate);
        }
        finally {
            TO_VALIDATE.clear();
            VALIDATING = false;
        }
        event.getServer().getAllLevels().forEach(serverLevel -> FastVolumeLookup.of((Level)serverLevel, TankMultiBlock.class).getAll().forEach(TankMultiBlock::tick));
        TO_SYNC.forEach(TankMultiBlock::sync);
        TO_SYNC.clear();
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (TankMultiBlock.this.fluidAmount == 0 || fluidType.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack copy = fluidType.copy();
            copy.setAmount(TankMultiBlock.this.fluidAmount);
            return copy;
        }

        public int getTankCapacity(int tank) {
            return TankMultiBlock.this.capacity;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            return fluidType.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)fluidType, (FluidStack)stack);
        }

        public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (!fluidType.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)fluidType, (FluidStack)resource)) {
                return 0;
            }
            return TankMultiBlock.this.parent.doFillLiquid(TankMultiBlock.this.getMultiTankFillOrder(), resource, resource.getAmount(), action);
        }

        @NotNull
        public FluidStack drain(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (fluidType.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)fluidType, (FluidStack)resource)) {
                return FluidStack.EMPTY;
            }
            return TankMultiBlock.this.parent.doDrainLiquid(TankMultiBlock.this.getMultiTankDrainOrder(), resource.getAmount(), action);
        }

        @NotNull
        public FluidStack drain(int amount, @NotNull IFluidHandler.FluidAction action) {
            if (amount == 0) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidType = TankMultiBlock.this.parent.getFluidType();
            if (fluidType.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return TankMultiBlock.this.parent.doDrainLiquid(TankMultiBlock.this.getMultiTankDrainOrder(), amount, action);
        }
    }

    public static class Container
    extends SimpleItemContainer {
        public Container() {
            super(4);
        }

        public boolean isValid(int slot, @NotNull ItemStack stack) {
            if (!super.isValid(slot, stack) || slot % 2 != 0) {
                return false;
            }
            IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (cap == null) {
                return false;
            }
            FluidStack fluid = cap.getFluidInTank(0);
            return slot == 0 && !fluid.isEmpty() || slot == 2 && cap.getTankCapacity(0) - fluid.getAmount() > 0;
        }
    }

    private class Section
    implements FluidAmountContainer {
        private final int capacity;
        private final int fluidUnderSection;

        private Section() {
            this.capacity = TankMultiBlock.this.getLayerCapacity() * this.getHeight();
            this.fluidUnderSection = (this.getBottom() - TankMultiBlock.this.getBottom()) * TankMultiBlock.this.getLayerCapacity();
        }

        public int getBottom() {
            return TankMultiBlock.this.getBottom();
        }

        public int getHeight() {
            return TankMultiBlock.this.getHeight();
        }

        @Override
        public int getCapacity() {
            return this.capacity;
        }

        @Override
        public int getFluidAmount() {
            return TankMultiBlock.this.getFluidAmount() - this.fluidUnderSection;
        }

        @Override
        public void setFluidAmount(int amount, TankOperation operation) {
            int fluidInTank = TankMultiBlock.this.getFluidAmount();
            int newFluidInTank = this.fluidUnderSection + amount;
            if (operation == TankOperation.FILL && fluidInTank >= newFluidInTank) {
                return;
            }
            if (operation == TankOperation.DRAIN && fluidInTank <= newFluidInTank) {
                return;
            }
            TankMultiBlock.this.setFluidAmount(newFluidInTank, operation);
        }

        public static class Group
        implements IOGroup {
            private final List<Section> sections;
            private final int gcd;
            private final long capacity;

            public Group(List<Section> sections) {
                this.sections = sections;
                this.gcd = FluidAmountContainer.getGCD(sections);
                this.capacity = FluidAmountContainer.getCapacity(sections);
            }

            @Override
            public long getCapacity() {
                return this.capacity;
            }

            @Override
            public long getFluidAmount() {
                return FluidAmountContainer.getFluidAmount(this.sections);
            }

            @Override
            public void setFluidAmount(long amount, TankOperation operation) {
                FluidAmountContainer.distribute(this.sections, this.capacity, this.gcd, amount, operation);
            }
        }
    }

    public record IDPair(UUID uuid, int id) {
        public static final Codec<IDPair> CODEC = RecordCodecBuilder.create((T builder) -> builder.group((App)UUIDUtil.CODEC.fieldOf("multi_tank_id").forGetter(IDPair::uuid), (App)Codec.INT.fieldOf("tank_id").forGetter(IDPair::id)).apply((Applicative)builder, IDPair::new));

        public static IDPair create(TankMultiBlock tank) {
            if (tank == null) {
                return null;
            }
            return new IDPair(tank.parent.getId(), tank.id);
        }
    }
}

