/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.InventoryAttachment;
import tv.soaryn.xycraft.machines.content.attachments.level.ProducerTickSystemLevelAttachment;
import tv.soaryn.xycraft.machines.content.recipes.producers.arkmelter.ArkMelterRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.ProducerTickSystem;

public class ArkMelterTickSystem
extends ProducerTickSystem<ArkMelterRecipe, ArkMelterRecipe.Input> {
    public static final Codec<ProducerTickSystemLevelAttachment<ArkMelterRecipe, ArkMelterRecipe.Input>> CODEC = RecordCodecBuilder.create(builder -> ProducerTickSystemLevelAttachment.producerGroup(builder).apply((Applicative)builder, (chunkMap, frequency, enabled) -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)chunkMap, (long)frequency, (boolean)enabled, (RecipeType)MachinesRecipeTypes.ArkMelter.type().get())));
    public static final AttachmentType.Builder<ProducerTickSystemLevelAttachment<ArkMelterRecipe, ArkMelterRecipe.Input>> Builder = AttachmentType.builder(() -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(), 10L, true, (RecipeType)MachinesRecipeTypes.ArkMelter.type().get())).serialize(CODEC);

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        throw new NotImplementedException();
    }

    protected void tickBlocks(ServerLevel level, ProducerTickSystemLevelAttachment<ArkMelterRecipe, ArkMelterRecipe.Input> tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        Either<FluidStack, ItemStack> out;
        ArkMelterRecipe recipe = this.getRecipe(level, tickData, (BlockPos)pos, state, currentStep);
        if (recipe == null) {
            return;
        }
        InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.Block.SoarynBoxData);
        Either<SizedFluidIngredient, SizedIngredient> in = recipe.input();
        if (!in.left().isPresent() && in.right().isPresent()) {
            ItemStack itemInSlot = data.getInventory().get(0);
            itemInSlot.shrink(((SizedIngredient)in.right().get()).count());
        }
        if (!(out = recipe.output()).left().isPresent() && out.right().isPresent()) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)data.Inventory.asHandler(), (ItemStack)((ItemStack)out.right().get()), (boolean)false);
        }
    }

    @Override
    public ArkMelterRecipe.Input getInput(ServerLevel level, ProducerTickSystemLevelAttachment<ArkMelterRecipe, ArkMelterRecipe.Input> tickData, BlockPos pos, BlockState state, long currentStep) {
        final InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity(pos)).getData(MachinesAttachments.Block.SoarynBoxData);
        return new ArkMelterRecipe.Input(){

            @Override
            @NotNull
            public ItemStack getInputItem() {
                return data.getInventory().get(0);
            }

            @Override
            @NotNull
            public FluidStack getInputFluid() {
                return FluidStack.EMPTY;
            }
        };
    }

    @Override
    public long getTimeRequired(ArkMelterRecipe recipe) {
        return recipe.ticks();
    }

    @NotNull
    protected Supplier<AttachmentType<ProducerTickSystemLevelAttachment<ArkMelterRecipe, ArkMelterRecipe.Input>>> getAttachmentType() {
        return MachinesAttachments.System.ArkMelterSystemData;
    }
}

