/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropRecipes;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalcustomization.loader.CropLoader;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class CropCreator {
    public static Crop create(ResourceLocation id, JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        JsonObject ingredient = json.has("ingredient") ? GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredient") : null;
        LazyIngredient material = LazyIngredient.EMPTY;
        if (ingredient != null) {
            if (ingredient.has("tag")) {
                String tag = GsonHelper.getAsString((JsonObject)ingredient, (String)"tag");
                material = LazyIngredient.tag((String)tag);
            } else if (ingredient.has("item")) {
                String item = GsonHelper.getAsString((JsonObject)ingredient, (String)"item");
                if (ingredient.has("components")) {
                    DataComponentMap components = (DataComponentMap)((Pair)DataComponentMap.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)ingredient.get("components")).getOrThrow(JsonSyntaxException::new)).getFirst();
                    material = LazyIngredient.item((String)item, (DataComponentMap)components);
                } else {
                    material = LazyIngredient.item((String)item);
                }
            } else {
                throw new JsonSyntaxException("Ingredient must have either 'item' or 'tag' property");
            }
        }
        Crop crop = new Crop(id, CropTier.ONE, CropType.RESOURCE, material);
        String tierId = GsonHelper.getAsString((JsonObject)json, (String)"tier");
        String typeId = GsonHelper.getAsString((JsonObject)json, (String)"type");
        CropLoader.CROP_TIER_MAP.put(crop, ResourceLocation.parse((String)tierId));
        CropLoader.CROP_TYPE_MAP.put(crop, ResourceLocation.parse((String)typeId));
        if (json.has("color")) {
            String color = GsonHelper.getAsString((JsonObject)json, (String)"color");
            int i = ParsingHelper.parseHex((String)color, (String)"color");
            crop.setColor(i);
        } else if (json.has("colors")) {
            int i;
            String color;
            JsonObject colors = GsonHelper.getAsJsonObject((JsonObject)json, (String)"colors");
            if (colors.has("flower")) {
                color = GsonHelper.getAsString((JsonObject)colors, (String)"flower");
                i = ParsingHelper.parseHex((String)color, (String)"flower");
                crop.setFlowerColor(i);
            }
            if (colors.has("essence")) {
                color = GsonHelper.getAsString((JsonObject)colors, (String)"essence");
                i = ParsingHelper.parseHex((String)color, (String)"essence");
                crop.setEssenceColor(i);
            }
            if (colors.has("seeds")) {
                color = GsonHelper.getAsString((JsonObject)colors, (String)"seeds");
                i = ParsingHelper.parseHex((String)color, (String)"seeds");
                crop.setSeedColor(i);
            }
        }
        CropTextures ctextures = crop.getTextures().setFlowerTexture(CropTextures.FLOWER_INGOT_BLANK).setEssenceTexture(CropTextures.ESSENCE_INGOT_BLANK).setSeedTexture(CropTextures.SEED_BLANK);
        if (json.has("textures")) {
            ResourceLocation location;
            JsonObject textures = GsonHelper.getAsJsonObject((JsonObject)json, (String)"textures");
            if (textures.has("flower")) {
                String texture = GsonHelper.getAsString((JsonObject)textures, (String)"flower");
                location = ResourceLocation.parse((String)texture);
                ctextures.setFlowerTexture(location);
            }
            if (textures.has("essence")) {
                String texture = GsonHelper.getAsString((JsonObject)textures, (String)"essence");
                location = ResourceLocation.parse((String)texture);
                ctextures.setEssenceTexture(location);
            }
            if (textures.has("seeds")) {
                String texture = GsonHelper.getAsString((JsonObject)textures, (String)"seeds");
                location = ResourceLocation.parse((String)texture);
                ctextures.setSeedTexture(location);
            }
        }
        if (json.has("name")) {
            String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
            crop.setDisplayName((Component)Component.literal((String)name));
        }
        if (json.has("baseSecondaryChance")) {
            double chance = GsonHelper.getAsDouble((JsonObject)json, (String)"baseSecondaryChance");
            crop.setBaseSecondaryChance(chance);
        }
        if (json.has("respectsEffectiveFarmland")) {
            boolean respects = GsonHelper.getAsBoolean((JsonObject)json, (String)"respectsEffectiveFarmland");
            crop.setRespectsEffectiveFarmland(respects);
        }
        if (json.has("enabled")) {
            boolean enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled");
            crop.setEnabled(enabled);
        }
        if (json.has("crux")) {
            String crux = GsonHelper.getAsString((JsonObject)json, (String)"crux");
            CropLoader.CRUX_MAP.put(crop, ResourceLocation.parse((String)crux));
        }
        if (json.has("glint")) {
            boolean glint = GsonHelper.getAsBoolean((JsonObject)json, (String)"glint");
            crop.setHasEffect(glint);
        }
        if (json.has("biomes")) {
            JsonArray biomes = GsonHelper.getAsJsonArray((JsonObject)json, (String)"biomes");
            biomes.forEach(biome -> crop.addRequiredBiome(ResourceLocation.parse((String)biome.getAsString())));
        }
        if (CropCreator.isGarbageSeed(crop.getName())) {
            DeferredHolder essence = null;
            if ("insanium".equals(crop.getName())) {
                if (ModList.get().isLoaded("mysticalagradditions")) {
                    essence = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mysticalagradditions", (String)crop.getNameWithSuffix("essence")));
                }
            } else {
                essence = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)crop.getNameWithSuffix("essence")));
            }
            if (essence != null) {
                crop.setEssenceItem((Supplier)essence);
            }
        }
        if (json.has("essence")) {
            String essence = GsonHelper.getAsString((JsonObject)json, (String)"essence");
            DeferredHolder item = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)essence));
            crop.setEssenceItem((Supplier)item);
        }
        if (json.has("recipes")) {
            JsonObject recipes = GsonHelper.getAsJsonObject((JsonObject)json, (String)"recipes");
            CropRecipes config = crop.getRecipeConfig();
            if (recipes.has("crafting")) {
                boolean enabled = GsonHelper.getAsBoolean((JsonObject)recipes, (String)"crafting");
                config.setSeedCraftingRecipeEnabled(enabled);
            }
            if (recipes.has("infusion")) {
                boolean enabled = GsonHelper.getAsBoolean((JsonObject)recipes, (String)"infusion");
                config.setSeedInfusionRecipeEnabled(enabled);
            }
            if (recipes.has("reprocessor")) {
                boolean enabled = GsonHelper.getAsBoolean((JsonObject)recipes, (String)"reprocessor");
                config.setSeedReprocessorRecipeEnabled(enabled);
            }
        }
        return crop;
    }

    private static boolean isGarbageSeed(String name) {
        return "prudentium".equals(name) || "tertium".equals(name) || "imperium".equals(name) || "supremium".equals(name) || "awakened_supremium".equals(name) || "insanium".equals(name) || "fertilized".equals(name);
    }
}

