/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.inventory;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.util.AFUtil;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class FEGenericStackInvStorage
implements IEnergyStorage {
    private final GenericInternalInventory inv;

    public FEGenericStackInvStorage(GenericInternalInventory inv) {
        this.inv = inv;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long inserted = 0L;
        long left = maxReceive;
        Actionable mode = Actionable.ofSimulate((boolean)simulate);
        for (int slot = 0; slot < this.inv.size(); ++slot) {
            long in = this.inv.insert(slot, (AEKey)FluxKey.of(EnergyType.FE), left, mode);
            inserted += in;
            if ((left -= in) <= 0L) break;
        }
        return (int)inserted;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long extracted = 0L;
        long left = maxExtract;
        Actionable mode = Actionable.ofSimulate((boolean)simulate);
        for (int slot = 0; slot < this.inv.size(); ++slot) {
            long out = this.inv.extract(slot, (AEKey)FluxKey.of(EnergyType.FE), left, mode);
            extracted += out;
            if ((left -= out) <= 0L) break;
        }
        return (int)extracted;
    }

    public int getEnergyStored() {
        GenericStack stack;
        long cnt = 0L;
        for (int slot = 0; !(slot >= this.inv.size() || (stack = this.inv.getStack(slot)) != null && FluxKey.of(EnergyType.FE).equals(stack.what()) && (cnt += stack.amount()) > Integer.MAX_VALUE); ++slot) {
        }
        return AFUtil.clampLong(cnt);
    }

    public int getMaxEnergyStored() {
        long cnt = 0L;
        for (int slot = 0; slot < this.inv.size(); ++slot) {
            GenericStack stack = this.inv.getStack(slot);
            if (stack != null) {
                if (!FluxKey.of(EnergyType.FE).equals(stack.what())) continue;
                ++cnt;
                continue;
            }
            ++cnt;
        }
        return AFUtil.clampLong(cnt * this.inv.getMaxAmount((AEKey)FluxKey.of(EnergyType.FE)));
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

