/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.tileentities;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.util.SettingsFrom;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.appflux.common.caps.NetworkFEPower;
import com.glodblock.github.appflux.common.me.energy.EnergyCapCache;
import com.glodblock.github.appflux.common.me.energy.EnergyHandler;
import com.glodblock.github.appflux.common.me.energy.EnergyTickRecord;
import com.glodblock.github.appflux.common.me.service.EnergyDistributeService;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.helpers.Constants;
import com.glodblock.github.glodium.util.GlodUtil;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class TileFluxAccessor
extends AENetworkedBlockEntity
implements IEnergyDistributor {
    private EnergyCapCache cacheApi;
    private boolean fast = false;
    private final Set<Direction> blocked = EnumSet.noneOf(Direction.class);
    private final Reference2ReferenceMap<Direction, EnergyTickRecord> lastTick = new Reference2ReferenceOpenHashMap();
    private final ICapabilityInvalidationListener[] listeners = new ICapabilityInvalidationListener[6];
    private final IActionSource source = IActionSource.ofMachine((IActionHost)this);

    public TileFluxAccessor(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileFluxAccessor.class, TileFluxAccessor::new, (Block)AFSingletons.FLUX_ACCESSOR), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getMainNode().setIdlePowerUsage(1.0).addService(IEnergyDistributor.class, (IGridNodeService)this);
        for (Direction d : Constants.ALL_DIRECTIONS_LIST) {
            this.listeners[d.get3DDataValue()] = () -> {
                if (this.isRemoved()) {
                    return false;
                }
                this.blocked.remove(d);
                return true;
            };
        }
    }

    public IActionSource getSource() {
        return this.source;
    }

    private void initCache() {
        this.cacheApi = new EnergyCapCache((ServerLevel)this.level, this.worldPosition, this::getGrid);
    }

    private IGrid getGrid() {
        if (this.getGridNode() == null) {
            return null;
        }
        return this.getGridNode().getGrid();
    }

    public IEnergyStorage getEnergyStorage() {
        if (this.getStorage() != null) {
            return new NetworkFEPower(this.getStorage(), this.source);
        }
        return new EnergyStorage(0);
    }

    public IStorageService getStorage() {
        if (this.getGridNode() != null) {
            return this.getGridNode().getGrid().getStorageService();
        }
        return null;
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (input.has(AFSingletons.FAST_MODE)) {
            this.fast = (Boolean)input.getOrDefault(AFSingletons.FAST_MODE, (Object)false);
        }
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.set(AFSingletons.FAST_MODE, (Object)this.fast);
        }
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.fast = data.getBoolean("fast");
    }

    public void saveAdditional(CompoundTag extra, HolderLookup.Provider registries) {
        super.saveAdditional(extra, registries);
        extra.putBoolean("fast", this.fast);
    }

    @Override
    public boolean isActive() {
        return this.getMainNode().isActive();
    }

    @Override
    public void distribute(long ticks) {
        if (this.level == null) {
            return;
        }
        if (this.cacheApi == null) {
            this.initCache();
        }
        IStorageService storage = this.getStorage();
        IGrid gird = this.getGrid();
        if (storage != null) {
            for (Direction d : Constants.ALL_DIRECTIONS_LIST) {
                if (this.blocked.contains(d)) continue;
                EnergyTickRecord tickRate = (EnergyTickRecord)this.lastTick.get((Object)d);
                if (!this.isFastMode() && !tickRate.needTick(ticks)) continue;
                long sent = EnergyHandler.send(this.cacheApi, d, storage, this.source);
                if (sent == -1L) {
                    this.blocked.add(d);
                    continue;
                }
                tickRate.sent(sent);
            }
            if (AFConfig.selfCharge() && gird != null) {
                EnergyHandler.chargeNetwork((IEnergyService)gird.getService(IEnergyService.class), storage, this.source);
            }
        }
    }

    @Override
    public void setServiceHost(@Nullable EnergyDistributeService service) {
        if (service != null) {
            service.wake(this);
            this.blocked.clear();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                for (Direction d : Constants.ALL_DIRECTIONS_LIST) {
                    BlockPos pos = this.getBlockPos().relative(d);
                    world.registerCapabilityListener(pos, this.listeners[d.get3DDataValue()]);
                    this.lastTick.put((Object)d, (Object)new EnergyTickRecord());
                }
            }
        }
    }

    @Override
    public boolean isFastMode() {
        return this.fast;
    }

    @Override
    public void setFastMode(boolean mode) {
        this.fast = mode;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (this.getMainNode().hasGridBooted()) {
            this.invalidateCapabilities();
        }
    }
}

