/*
 * Decompiled with CFR 0.152.
 */
package rainbows.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import rainbows.Rainbows;
import rainbows.util.RHelpers;
import rainbows.util.RainbowsData;
import rainbows.util.RainbowsRendererParticle;

public class ClientEventHandler {
    public static final ConcurrentMap<ResourceKey<Level>, RainbowsRendererParticle> HAS_RAINBOW = new ConcurrentHashMap<ResourceKey<Level>, RainbowsRendererParticle>();

    public static void init(ModContainer mod, IEventBus modBus) {
        IEventBus bus = NeoForge.EVENT_BUS;
        modBus.addListener(ClientEventHandler::registerKeyBindings);
        bus.addListener(ClientEventHandler::onKeyEvent);
        bus.addListener(ClientEventHandler::onWorldLoad);
        bus.addListener(ClientEventHandler::handleRainbow);
        bus.addListener(ClientEventHandler::onWorldUnload);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(RHelpers.RELOAD_RAINBOW_CONFIGS);
    }

    public static void onKeyEvent(InputEvent.Key event) {
        if (RHelpers.RELOAD_RAINBOW_CONFIGS.isDown()) {
            RainbowsData.createConfigs();
            RainbowsData.updateConfigs();
        }
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        RainbowsData.createConfigs();
        RainbowsData.updateConfigs();
        HAS_RAINBOW.clear();
    }

    public static void onWorldUnload(LevelEvent.Unload event) {
        HAS_RAINBOW.clear();
    }

    public static void handleRainbow(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            LocalPlayer player = minecraft.player;
            ClientLevel level = minecraft.level;
            if (player != null && level != null) {
                for (RainbowsData data : RainbowsData.getDataList((Level)level)) {
                    if (data == null) continue;
                    for (String dimension : data.allowedDimensions) {
                        ResourceKey dimensionKey;
                        if (!dimension.equals((dimensionKey = level.dimension()).location().toString()) || HAS_RAINBOW.containsKey(dimensionKey)) continue;
                        Rainbows.LOGGER.info("Added rainbow to dimension " + dimension);
                        RainbowsRendererParticle rainbowParticle = new RainbowsRendererParticle(level, player.position(), (Player)player, data, (ResourceKey<Level>)dimensionKey);
                        minecraft.particleEngine.add((Particle)rainbowParticle);
                        HAS_RAINBOW.put((ResourceKey<Level>)dimensionKey, rainbowParticle);
                    }
                }
            }
        }
    }
}

