/*
 * Decompiled with CFR 0.152.
 */
package rainbows.config;

import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;

public class RainbowsConfig {
    public final ModConfigSpec.BooleanValue globalDetailOverride;
    public final ModConfigSpec.BooleanValue globalShouldAutoUpdate;
    public final ModConfigSpec.IntValue rainbowDetail;
    public final ModConfigSpec.IntValue rainbowColorDetail;
    public final ModConfigSpec.DoubleValue rainbowBrightnessIncreaseFactor;
    public final ModConfigSpec.DoubleValue sunRotation;

    RainbowsConfig(ModConfigSpec.Builder innerBuilder) {
        Function<String, ModConfigSpec.Builder> builder = name -> innerBuilder.translation("rainbows.config.common." + name);
        innerBuilder.push("General");
        this.globalDetailOverride = builder.apply("globalDetailOverride").comment("Global toggle for controlling rainbow detail.").define("globalDetailOverride", false);
        this.globalShouldAutoUpdate = builder.apply("globalShouldAutoUpdate").comment("If set to true, then the configs will update every mod update. Set to false if you want to manage config changes yourself.").define("globalShouldAutoUpdate", true);
        this.rainbowDetail = builder.apply("rainbowDetail").comment("How high of a resolution should the rainbow render in? Lower value = lower resolution and quality but more FPS.").defineInRange("rainbowDetail", 150, 0, Integer.MAX_VALUE);
        this.rainbowColorDetail = builder.apply("rainbowColorDetail").comment("How high of a fidelity should the rainbow gradient layers have? Lower value = less gradient layers but more FPS.").defineInRange("rainbowColorDetail", 32, 1, Integer.MAX_VALUE);
        this.rainbowBrightnessIncreaseFactor = builder.apply("rainbowBrightnessIncreaseFactor").comment("Brightness multiplier value added to the colors of the rainbow. 0 = no change, 1 = fully white.").defineInRange("rainbowBrightnessIncreaseFactor", 0.25, 0.0, 1.0);
        this.sunRotation = builder.apply("sunRotation").comment("Sun rotation.").defineInRange("sunRotation", 39.0, -360.0, 360.0);
        innerBuilder.pop();
    }
}

