/*
 * Decompiled with CFR 0.152.
 */
package rainbows.util;

import rainbows.util.FastNoiseLite;
import rainbows.util.Noise2D;

public class OpenSimplex2D
implements Noise2D {
    final FastNoiseLite fnl;
    private double frequency;
    private double midpoint;
    private double amplitude;

    public OpenSimplex2D(long seed) {
        this((int)(seed ^ seed >> 32));
    }

    public OpenSimplex2D(int seed) {
        this.fnl = new FastNoiseLite(seed);
        this.fnl.SetFrequency(1.0);
        this.fnl.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        this.fnl.SetFractalOctaves(1);
        this.frequency = 1.0;
        this.midpoint = 0.0;
        this.amplitude = 1.0;
    }

    @Override
    public double noise(double x, double z) {
        return this.midpoint + (double)this.fnl.GetNoise(x, z) * this.amplitude;
    }

    @Override
    public OpenSimplex2D octaves(int octaves) {
        this.fnl.SetFractalOctaves(octaves);
        this.fnl.SetFractalType(FastNoiseLite.FractalType.FBm);
        return this.spread(1.0f / (float)(1 << octaves - 1));
    }

    @Override
    public OpenSimplex2D spread(double scaleFactor) {
        this.frequency *= scaleFactor;
        this.fnl.SetFrequency(this.frequency);
        return this;
    }

    @Override
    public OpenSimplex2D scaled(double min, double max) {
        return this.scaled(-1.0, 1.0, min, max);
    }

    @Override
    public OpenSimplex2D scaled(double oldMin, double oldMax, double min, double max) {
        assert (oldMin == -1.0 && oldMax == 1.0);
        this.midpoint = (max + min) / 2.0;
        this.amplitude = (max - min) / 2.0;
        return this;
    }

    double getAmplitude() {
        return this.amplitude;
    }
}

