/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.util.config;

import com.cursee.monolib.core.util.config.SimpleConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class SimpleConfigIO {
    public static String formatValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return "\"" + s.replace("\"", "\\\"") + "\"";
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> formatted = new ArrayList<String>();
            for (Object item : list) {
                formatted.add(SimpleConfigIO.formatValue(item));
            }
            return "[" + String.join((CharSequence)", ", formatted) + "]";
        }
        return value.toString();
    }

    public static void save(@NotNull SimpleConfig config, Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            TreeMap<String, List> sectioned = new TreeMap<String, List>();
            for (String string : config.keys()) {
                String[] parts = string.split("\\.");
                String section = parts.length > 1 ? String.join((CharSequence)".", Arrays.copyOf(parts, parts.length - 1)) : "";
                String entry = parts[parts.length - 1] + " = " + SimpleConfigIO.formatValue(config.get(string));
                sectioned.computeIfAbsent(section, k -> new ArrayList()).add(entry);
            }
            for (Map.Entry entry : sectioned.entrySet()) {
                if (!((String)entry.getKey()).isEmpty()) {
                    writer.write("[" + (String)entry.getKey() + "]");
                    writer.newLine();
                }
                for (String line : (List)entry.getValue()) {
                    writer.write(line);
                    writer.newLine();
                    if (line.startsWith("#")) continue;
                    writer.newLine();
                }
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to save config to " + String.valueOf(path), e);
        }
    }

    private static List<String> splitRespectingQuotes(String raw) {
        ArrayList<String> result = new ArrayList<String>();
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder();
        for (char c : raw.toCharArray()) {
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == ',' && !inQuotes) {
                result.add(sb.toString().trim());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(sb.toString().trim());
        }
        return result;
    }

    public static Object parseValue(String raw) {
        if (raw.startsWith("[") && raw.endsWith("]")) {
            ArrayList<Object> list = new ArrayList<Object>();
            String inner = raw.substring(1, raw.length() - 1).trim();
            List<String> elements = SimpleConfigIO.splitRespectingQuotes(inner);
            for (String el : elements) {
                list.add(SimpleConfigIO.parseValue(el.trim()));
            }
            return list;
        }
        if (raw.startsWith("\"") && raw.endsWith("\"")) {
            return raw.substring(1, raw.length() - 1);
        }
        if (raw.equals("true") || raw.equals("false")) {
            return Boolean.parseBoolean(raw);
        }
        if (raw.contains(".")) {
            try {
                return Float.valueOf(Float.parseFloat(raw));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Integer.parseInt(raw);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("SimpleConfig failed to parse value: " + raw);
        }
    }

    @NotNull
    public static SimpleConfig load(SimpleConfig config, Path path) {
        try {
            return SimpleConfigIO.load(config, Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load config from " + String.valueOf(path), e);
        }
    }

    @NotNull
    public static SimpleConfig load(SimpleConfig config, List<String> tomlString) {
        ArrayList<Object> currentPath = new ArrayList();
        for (String line : tomlString) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String sectionHeader = line.substring(1, line.length() - 1);
                currentPath = new ArrayList<String>(Arrays.asList(sectionHeader.split("\\.")));
                continue;
            }
            int eqIdx = line.indexOf("=");
            if (eqIdx == -1) continue;
            String key = line.substring(0, eqIdx).trim();
            String rawValue = line.substring(eqIdx + 1).trim();
            String fullKey = String.join((CharSequence)".", currentPath) + "." + key;
            Object value = SimpleConfigIO.parseValue(rawValue);
            config.putEntry(fullKey, value, false);
        }
        return config;
    }
}

