/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public final class GlodCodecs {
    public static final StreamCodec<RegistryFriendlyByteBuf, CompoundTag> NBT_STREAM_CODEC = StreamCodec.of((buf, tag) -> buf.writeNbt((Tag)tag), buf -> Objects.requireNonNull(buf.readNbt()));

    private GlodCodecs() {
    }

    public static <A, B> Codec<Pair<A, B>> pair(Codec<A> first, Codec<B> second) {
        return RecordCodecBuilder.create(builder -> builder.group((App)first.fieldOf("a").forGetter(Pair::left), (App)second.fieldOf("b").forGetter(Pair::right)).apply((Applicative)builder, Pair::of));
    }

    public static <K, V> Codec<Map<K, V>> map(Codec<K> key, Codec<V> value) {
        return GlodCodecs.map(key, value, HashMap::new);
    }

    public static <K, V> Codec<Map<K, V>> map(Codec<K> key, Codec<V> value, Supplier<? extends Map<K, V>> collector) {
        return Codec.list(GlodCodecs.pair(key, value)).xmap(list -> {
            Map map = (Map)collector.get();
            list.forEach(p -> map.put(p.left(), p.right()));
            return map;
        }, map -> {
            ArrayList list = new ArrayList();
            map.forEach((k, v) -> list.add(Pair.of((Object)k, (Object)v)));
            return list;
        });
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, List<T>> list(StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return StreamCodec.of((buf, l) -> {
            buf.writeInt(l.size());
            l.forEach(o -> codec.encode(buf, o));
        }, buf -> {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int size = buf.readInt(); size > 0; --size) {
                list.add(codec.decode(buf));
            }
            return list;
        });
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Optional<T>> optional(StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return StreamCodec.of((buf, op) -> {
            buf.writeBoolean(op.isPresent());
            op.ifPresent(o -> codec.encode(buf, o));
        }, buf -> {
            if (buf.readBoolean()) {
                return Optional.of(codec.decode(buf));
            }
            return Optional.empty();
        });
    }

    public static <A, B> StreamCodec<RegistryFriendlyByteBuf, Pair<A, B>> pair(StreamCodec<? super RegistryFriendlyByteBuf, A> first, StreamCodec<? super RegistryFriendlyByteBuf, B> second) {
        return StreamCodec.composite(first, Pair::left, second, Pair::right, Pair::of);
    }
}

