/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.util.InventoryUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.neoforged.neoforge.items.ComponentItemHandler;

public class HeartAmuletRecipe
extends ShapelessRecipe {
    final String group;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;

    public HeartAmuletRecipe(String group, ItemStack stack, NonNullList<Ingredient> list) {
        super(group, CraftingBookCategory.EQUIPMENT, stack, list);
        this.group = group;
        this.result = stack;
        this.ingredients = list;
    }

    public ItemStack assemble(CraftingInput craftingContainer, HolderLookup.Provider registries) {
        ItemStack stack = super.assemble(craftingContainer, registries);
        ItemStack oldCanister = ItemStack.EMPTY;
        for (int i = 0; i < craftingContainer.size(); ++i) {
            ItemStack input = craftingContainer.getItem(i);
            if (input.getItem() != RegistryHandler.HEART_AMULET.get()) continue;
            oldCanister = input;
            break;
        }
        ComponentItemHandler oldInv = InventoryUtil.createVirtualInventory(4, oldCanister);
        ComponentItemHandler newInv = InventoryUtil.createVirtualInventory(5, stack);
        for (int i = 0; i < oldInv.getSlots(); ++i) {
            newInv.setStackInSlot(i, oldInv.getStackInSlot(i));
        }
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryHandler.HEART_AMULET_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<HeartAmuletRecipe> {
        private static final MapCodec<HeartAmuletRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(array -> {
            Object[] aingredient = (Ingredient[])array.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for heart amulet recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, HeartAmuletRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, HeartAmuletRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<HeartAmuletRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HeartAmuletRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, HeartAmuletRecipe heartAmuletRecipe) {
            buf.writeUtf(heartAmuletRecipe.group);
            buf.writeVarInt(heartAmuletRecipe.ingredients.size());
            for (Ingredient ingredient : heartAmuletRecipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)heartAmuletRecipe.result);
        }

        private static HeartAmuletRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            int size = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new HeartAmuletRecipe(group, result, (NonNullList<Ingredient>)ingredients);
        }
    }
}

