/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.items.ItemSoulHeartAmulet;
import com.traverse.bhc.common.util.InventoryUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="bhc")
public class PlayerDeathEvent {
    @SubscribeEvent
    public static void onPlayerDeathEvent(LivingDeathEvent evt) {
        LivingEntity livingEntity;
        if (!evt.getEntity().level().isClientSide() && (livingEntity = evt.getEntity()) instanceof Player) {
            ComponentItemHandler soulInventory;
            Player player = (Player)livingEntity;
            ICuriosItemHandler handler = CuriosApi.getCuriosInventory((LivingEntity)evt.getEntity()).orElse(null);
            if (handler == null) {
                return;
            }
            SlotResult equipped = handler.findFirstCurio(itemStack -> itemStack.getItem() instanceof ItemSoulHeartAmulet).orElse(null);
            if (equipped != null && !(soulInventory = InventoryUtil.createVirtualInventory(5, equipped.stack())).getStackInSlot(4).isEmpty()) {
                ItemStack stack = soulInventory.getStackInSlot(4);
                stack.shrink(1);
                soulInventory.setStackInSlot(4, stack);
                player.displayClientMessage((Component)Component.translatable((String)Util.makeDescriptionId((String)"message", (ResourceLocation)BaubleyHeartCanisters.id("soul_heart_used"))).setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_PURPLE)), true);
                player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.TOTEM_USE, player.getSoundSource(), 1.0f, 1.0f, false);
                if (player.getRandom().nextDouble() <= (Double)ConfigHandler.general.soulHeartReturnChance.get()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)RegistryHandler.BLUE_CANISTER.get()));
                }
                evt.setCanceled(true);
                player.setHealth(player.getMaxHealth());
                player.removeAllEffects();
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            }
        }
    }
}

