/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data.client;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.ModRegistry;
import com.Pdiddy973.AllTheCompressed.data.LanguageUtil;
import com.Pdiddy973.AllTheCompressed.overlay.Overlays;
import com.Pdiddy973.AllTheCompressed.util.TranslationKey;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class Languages {
    private Languages() {
    }

    public static class English
    extends LanguageProvider {
        private final LanguageUtil languageUtil;

        public English(PackOutput packOutput, ExistingFileHelper fileHelper) {
            super(packOutput, "allthecompressed", "en_us");
            this.languageUtil = new LanguageUtil(fileHelper);
        }

        protected void addTranslations() {
            this.add(TranslationKey.tab(), "AllTheCompressed");
            this.add(TranslationKey.tooltip("quantity"), "Total blocks: %s");
            this.addBlock((Supplier)ModRegistry.FLINT_BLOCK, "Flint Block");
            this.addBlock((Supplier)ModRegistry.BLAZE_ROD_BLOCK, "Blaze Rod Block");
            this.addBlock((Supplier)ModRegistry.ANTIMATTER_BLOCK, "Antimatter Block");
            for (Overlays value : Overlays.values()) {
                ResourceLocation parent = value.overlay.parent;
                Optional block = BuiltInRegistries.BLOCK.getOptional(parent);
                if (block.isEmpty() || block.get() == Blocks.AIR) {
                    AllTheCompressed.LOGGER.error("missing block during datagen: {}", (Object)parent);
                    continue;
                }
                String parentName = this.languageUtil.getParentName(parent);
                for (int i = 0; i < 9; ++i) {
                    this.add((Item)value.overlay.iall.get(i).get(), String.format("%s %sx", parentName, i + 1));
                }
            }
        }

        public void add(String key, String value) {
            super.add(key, value);
            this.languageUtil.put(key, value);
        }
    }
}

