/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data.compat;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.overlay.Overlays;
import com.Pdiddy973.AllTheCompressed.util.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import owmii.powah.block.energizing.EnergizingRecipe;

public class EnergizingRecipeBuilder {
    final Overlays overlay;
    final int count;
    long energy = 0L;
    List<Overlays> ingredients = new ArrayList<Overlays>();

    public EnergizingRecipeBuilder(Overlays overlay, int count) {
        this.overlay = overlay;
        this.count = count;
    }

    public static EnergizingRecipeBuilder build(Overlays overlays) {
        return new EnergizingRecipeBuilder(overlays, 1);
    }

    public static EnergizingRecipeBuilder build(Overlays overlays, int count) {
        return new EnergizingRecipeBuilder(overlays, count);
    }

    public EnergizingRecipeBuilder setEnergy(long energy) {
        this.energy = energy;
        return this;
    }

    public EnergizingRecipeBuilder addIngredient(Overlays ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public void save(RecipeOutput powah) {
        for (int i = 0; i < 10; ++i) {
            ItemStack output;
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            long totalEnergy = this.energy * (long)Math.pow(9.0, i);
            if (totalEnergy > Integer.MAX_VALUE) {
                return;
            }
            if (i == 0) {
                ResourceLocation parent = this.overlay.overlay.parent;
                Optional block = BuiltInRegistries.BLOCK.getOptional(parent);
                if (block.isEmpty() || block.get() == Blocks.AIR) {
                    AllTheCompressed.LOGGER.error("missing block during datagen: {}", (Object)parent);
                    continue;
                }
                output = new ItemStack((ItemLike)block.get(), this.count);
                for (Overlays ingredient : this.ingredients) {
                    Block iblock = (Block)BuiltInRegistries.BLOCK.getOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ingredient.overlay.parent));
                    inputs.add(Ingredient.of((ItemLike[])new ItemLike[]{iblock}));
                }
            } else {
                output = this.overlay.overlay.iall.get(i - 1).toStack().copyWithCount(this.count);
                for (Overlays ingredient : this.ingredients) {
                    inputs.add(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredient.overlay.iall.get(i - 1)}));
                }
            }
            String path = String.format("energizing/%s/x%d", this.overlay.overlay.parent.getPath(), i);
            powah.accept(ResourceUtil.prefix(path), (Recipe)new EnergizingRecipe(output, totalEnergy, inputs), null);
        }
    }
}

