/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data.server;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.overlay.Overlays;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTags
extends BlockTagsProvider {
    public BlockTags(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), lookupProvider, "allthecompressed", existingFileHelper);
    }

    protected ResourceManager getManagerViaReflection() {
        try {
            Method method = Objects.requireNonNull(this.existingFileHelper).getClass().getDeclaredMethod("getManager", PackType.class);
            method.setAccessible(true);
            return (ResourceManager)method.invoke((Object)this.existingFileHelper, PackType.SERVER_DATA);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new RuntimeException("Failed to reflect into ExistingFileHelper", e);
        }
    }

    protected void addTags(HolderLookup.Provider provider) {
        TagLoader tagLoader = new TagLoader(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getHolder(arg_0), Registries.tagsDirPath((ResourceKey)Registries.BLOCK));
        Map resourceMap = tagLoader.loadAndBuild(this.getManagerViaReflection());
        Map<TagKey, List> tagMap = resourceMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)((ResourceLocation)entry.getKey())), entry -> List.copyOf((Collection)entry.getValue())));
        for (Overlays value : Overlays.values()) {
            ResourceLocation parent = value.overlay.parent;
            Optional block = BuiltInRegistries.BLOCK.getOptional(parent);
            Holder parentHolder = BuiltInRegistries.BLOCK.getHolder(parent).orElse(null);
            if (block.isEmpty() || block.get() == Blocks.AIR) {
                AllTheCompressed.LOGGER.error("missing block during datagen: {}", (Object)parent);
                continue;
            }
            Object[] blocks = (Block[])value.overlay.xall.stream().map(Supplier::get).toArray(Block[]::new);
            for (TagKey mineable : List.of(net.minecraft.tags.BlockTags.MINEABLE_WITH_PICKAXE, net.minecraft.tags.BlockTags.MINEABLE_WITH_AXE, net.minecraft.tags.BlockTags.MINEABLE_WITH_HOE, net.minecraft.tags.BlockTags.MINEABLE_WITH_SHOVEL, net.minecraft.tags.BlockTags.SWORD_EFFICIENT, net.minecraft.tags.BlockTags.NEEDS_DIAMOND_TOOL, net.minecraft.tags.BlockTags.NEEDS_IRON_TOOL, net.minecraft.tags.BlockTags.NEEDS_STONE_TOOL, net.minecraft.tags.BlockTags.BEACON_BASE_BLOCKS, net.minecraft.tags.BlockTags.SOUL_FIRE_BASE_BLOCKS, net.minecraft.tags.BlockTags.SOUL_SPEED_BLOCKS)) {
                if (!tagMap.get(mineable).contains(parentHolder)) continue;
                AllTheCompressed.LOGGER.info("adding tag {} for block {}", (Object)mineable, (Object)parent);
                this.tag(mineable).add(blocks);
            }
        }
    }
}

