/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import dev.qther.ars_unification.processors.Processor;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public abstract class MIProcessor
extends Processor<RecipeInput, MachineRecipe> {
    public Fluid[] ignoredFluids;

    public MIProcessor(MinecraftServer server, RecipeType<MachineRecipe> type, Fluid[] ignoredFluids) {
        super(server, type);
        this.ignoredFluids = ignoredFluids;
    }

    public MIProcessor(MinecraftServer server, RecipeType<MachineRecipe> type) {
        this(server, type, new Fluid[0]);
    }

    @Override
    @Nullable
    public Ingredient getIngredient(MachineRecipe recipe) {
        if (!recipe.fluidOutputs.isEmpty()) {
            return null;
        }
        if (this.ignoredFluids.length == 0 && !recipe.fluidInputs.isEmpty()) {
            return null;
        }
        for (MachineRecipe.FluidInput fluidIn : recipe.fluidInputs) {
            FluidStack[] fluidStacks = fluidIn.fluid().getStacks();
            boolean isIgnored = fluidStacks.length == 0;
            block1: for (FluidStack fluid : fluidStacks) {
                for (Fluid ignored : this.ignoredFluids) {
                    if (!fluid.is(ignored)) continue;
                    isIgnored = true;
                    break block1;
                }
            }
            if (isIgnored) continue;
            return null;
        }
        List ingredientList = recipe.itemInputs;
        if (ingredientList.size() != 1) {
            return Ingredient.EMPTY;
        }
        MachineRecipe.ItemInput first = (MachineRecipe.ItemInput)ingredientList.getFirst();
        Ingredient ingredient = first.ingredient();
        if (ingredient.isEmpty() || first.amount() != 1) {
            return Ingredient.EMPTY;
        }
        return ingredient;
    }
}

