/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.crush;

import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class MekanismCrusherProcessor
extends Processor<SingleRecipeInput, ItemStackToItemStackRecipe> {
    public MekanismCrusherProcessor(MinecraftServer server) {
        super(server, (RecipeType)MekanismRecipeTypes.TYPE_CRUSHING.get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.crushRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(ItemStackToItemStackRecipe recipe) {
        SizedIngredient sized = recipe.getInput().ingredient();
        if (sized.count() != 1) {
            return null;
        }
        Ingredient ingredient = sized.ingredient();
        if (ingredient.isEmpty()) {
            return null;
        }
        return ingredient;
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends ItemStackToItemStackRecipe> recipeHolder, Ingredient ingredient) {
        RecipeWrapper.Crush wrapper = new RecipeWrapper.Crush(recipeHolder.id(), ingredient);
        for (ItemStack output : ((ItemStackToItemStackRecipe)recipeHolder.value()).getOutputDefinition()) {
            wrapper = wrapper.withItems(output.copy());
        }
        return wrapper.asHolder();
    }
}

