/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.crush;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.crafting.recipe.TieredSingleRecipeInput;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class OccultismCrusherProcessor
extends Processor<TieredSingleRecipeInput, CrushingRecipe> {
    public OccultismCrusherProcessor(MinecraftServer server) {
        super(server, (RecipeType)OccultismRecipes.CRUSHING_TYPE.get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.crushRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(CrushingRecipe recipe) {
        NonNullList ingredients = recipe.getIngredients();
        if (ingredients.size() != 1 || ((Ingredient)ingredients.getFirst()).isEmpty() || !OccultismCrusherProcessor.doesTierMatch(recipe)) {
            return null;
        }
        return (Ingredient)ingredients.getFirst();
    }

    private static boolean doesTierMatch(CrushingRecipe recipe) {
        int tier = Config.CONFIG.OCCULTISM_CRUSHER_TIER.getAsInt();
        boolean tierMatches = true;
        int minTier = recipe.getMinTier();
        int maxTier = recipe.getMaxTier();
        if (minTier >= 0 && maxTier >= 0) {
            tierMatches = tier >= minTier && tier <= maxTier;
        } else if (minTier >= 0) {
            tierMatches = tier >= minTier;
        } else if (maxTier >= 0) {
            tierMatches = tier <= maxTier;
        }
        return tierMatches;
    }

    public static float getMultiplier() {
        int tier = Config.CONFIG.OCCULTISM_CRUSHER_TIER.getAsInt();
        ModConfigSpec.DoubleValue config = switch (tier) {
            case 1 -> Occultism.SERVER_CONFIG.spiritJobs.tier1CrusherOutputMultiplier;
            case 2 -> Occultism.SERVER_CONFIG.spiritJobs.tier2CrusherOutputMultiplier;
            case 3 -> Occultism.SERVER_CONFIG.spiritJobs.tier3CrusherOutputMultiplier;
            case 4 -> Occultism.SERVER_CONFIG.spiritJobs.tier4CrusherOutputMultiplier;
            default -> {
                ArsUnification.LOGGER.warn("Unknown Occultism crusher tier {}", (Object)tier);
                yield Occultism.SERVER_CONFIG.spiritJobs.tier1CrusherOutputMultiplier;
            }
        };
        return ((Double)config.get()).floatValue();
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends CrushingRecipe> recipeHolder, Ingredient ingredient) {
        ItemStack result;
        CrushingRecipe recipe = (CrushingRecipe)recipeHolder.value();
        RecipeWrapper.Crush wrapper = new RecipeWrapper.Crush(recipeHolder.id(), ingredient);
        try {
            result = recipe.getResultItem((HolderLookup.Provider)this.registryAccess()).copy();
        }
        catch (Exception e) {
            ArsUnification.LOGGER.warn("Failed to get result item", (Throwable)e);
            return null;
        }
        float outputMultiplier = recipe.getIgnoreCrushingMultiplier() ? 1.0f : OccultismCrusherProcessor.getMultiplier();
        result.setCount((int)((float)result.getCount() * outputMultiplier));
        wrapper = wrapper.withItems(result);
        return wrapper.asHolder();
    }
}

